/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.helpers.HopperCounter;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.class_1767;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class CounterCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        LiteralArgumentBuilder commandBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"counter").requires(c -> CarpetSettings.hopperCounters)).executes(c -> CounterCommand.listAllCounters((class_2168)c.getSource(), false))).then(class_2170.method_9247((String)"reset").executes(c -> CounterCommand.resetCounters((class_2168)c.getSource())));
        for (class_1767 dyeColor : class_1767.values()) {
            commandBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)dyeColor.toString()).executes(c -> CounterCommand.displayCounter((class_2168)c.getSource(), dyeColor, false))).then(class_2170.method_9247((String)"reset").executes(c -> CounterCommand.resetCounter((class_2168)c.getSource(), dyeColor)))).then(class_2170.method_9247((String)"realtime").executes(c -> CounterCommand.displayCounter((class_2168)c.getSource(), dyeColor, true))));
        }
        dispatcher.register(commandBuilder);
    }

    private static int displayCounter(class_2168 source, class_1767 color, boolean realtime) {
        HopperCounter counter = HopperCounter.getCounter(color);
        for (class_2561 message : counter.format(source.method_9211(), realtime, false)) {
            source.method_9226(() -> message, false);
        }
        return 1;
    }

    private static int resetCounters(class_2168 source) {
        HopperCounter.resetAll(source.method_9211(), false);
        Messenger.m(source, "w Restarted all counters");
        return 1;
    }

    private static int resetCounter(class_2168 source, class_1767 color) {
        HopperCounter.getCounter(color).reset(source.method_9211());
        Messenger.m(source, "w Restarted " + String.valueOf(color) + " counter");
        return 1;
    }

    private static int listAllCounters(class_2168 source, boolean realtime) {
        for (class_2561 message : HopperCounter.formatAll(source.method_9211(), realtime)) {
            source.method_9226(() -> message, false);
        }
        return 1;
    }
}

