/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.CarpetContext;
import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Module;
import carpet.script.ScriptHost;
import carpet.script.Token;
import carpet.script.annotation.AnnotationParser;
import carpet.script.api.Auxiliary;
import carpet.script.api.BlockIterators;
import carpet.script.api.Entities;
import carpet.script.api.Inventories;
import carpet.script.api.Monitoring;
import carpet.script.api.Scoreboards;
import carpet.script.api.Threading;
import carpet.script.api.WorldAccess;
import carpet.script.exception.CarpetExpressionException;
import carpet.script.exception.ExpressionException;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.value.BlockValue;
import carpet.script.value.EntityValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class CarpetExpression {
    private final class_2168 source;
    private final class_2338 origin;
    private final Expression expr;

    public Expression getExpr() {
        return this.expr;
    }

    public class_2168 getSource() {
        return this.source;
    }

    public class_2338 getOrigin() {
        return this.origin;
    }

    public CarpetExpression(@Nullable Module module, String expression, class_2168 source, class_2338 origin) {
        this.origin = origin;
        this.source = source;
        this.expr = new Expression(expression);
        this.expr.asAModule(module);
        WorldAccess.apply(this.expr);
        Entities.apply(this.expr);
        Inventories.apply(this.expr);
        BlockIterators.apply(this.expr);
        Auxiliary.apply(this.expr);
        Threading.apply(this.expr);
        Scoreboards.apply(this.expr);
        Monitoring.apply(this.expr);
        AnnotationParser.apply(this.expr);
        Carpet.handleExtensionsAPI(this);
    }

    public boolean fillAndScanCommand(ScriptHost host, int x, int y, int z) {
        CarpetScriptServer scriptServer = (CarpetScriptServer)host.scriptServer();
        if (scriptServer.stopAll) {
            return false;
        }
        try {
            Context context = new CarpetContext(host, this.source, this.origin).with("x", (c, t) -> new NumericValue(x - this.origin.method_10263()).bindTo("x")).with("y", (c, t) -> new NumericValue(y - this.origin.method_10264()).bindTo("y")).with("z", (c, t) -> new NumericValue(z - this.origin.method_10260()).bindTo("z")).with("_", (c, t) -> new BlockValue(null, this.source.method_9225(), new class_2338(x, y, z)).bindTo("_"));
            class_1297 e = this.source.method_9228();
            if (e == null) {
                Value nullPlayer = Value.NULL.reboundedTo("p");
                context.with("p", (cc, tt) -> nullPlayer);
            } else {
                Value playerValue = new EntityValue(e).bindTo("p");
                context.with("p", (cc, tt) -> playerValue);
            }
            return scriptServer.events.handleEvents.getWhileDisabled(() -> ((Value)this.expr.executeAndEvaluate(context, Vanilla.ScriptServer_scriptOptimizations(scriptServer.server), host.loadOverrides, Vanilla.ScriptServer_scriptDebugging(scriptServer.server) ? arg_0 -> ((Logger)CarpetScriptServer.LOG).info(arg_0) : null).getLeft()).getBoolean());
        }
        catch (ExpressionException e) {
            throw new CarpetExpressionException(e.getMessage(), e.stack);
        }
        catch (ArithmeticException ae) {
            throw new CarpetExpressionException("Math doesn't compute... " + ae.getMessage(), null);
        }
        catch (StackOverflowError soe) {
            throw new CarpetExpressionException("Your thoughts are too deep", null);
        }
    }

    public Pair<Value, Expression.ExpressionNode> scriptRunCommand(ScriptHost host, class_2338 pos) {
        CarpetScriptServer scriptServer = (CarpetScriptServer)host.scriptServer();
        if (scriptServer.stopAll) {
            throw new CarpetExpressionException("SCRIPTING PAUSED (unpause with /script resume)", null);
        }
        try {
            Context context = new CarpetContext(host, this.source, this.origin).with("x", (c, t) -> new NumericValue(pos.method_10263() - this.origin.method_10263()).bindTo("x")).with("y", (c, t) -> new NumericValue(pos.method_10264() - this.origin.method_10264()).bindTo("y")).with("z", (c, t) -> new NumericValue(pos.method_10260() - this.origin.method_10260()).bindTo("z"));
            class_1297 e = this.source.method_9228();
            if (e == null) {
                Value nullPlayer = Value.NULL.reboundedTo("p");
                context.with("p", (cc, tt) -> nullPlayer);
            } else {
                Value playerValue = new EntityValue(e).bindTo("p");
                context.with("p", (cc, tt) -> playerValue);
            }
            return scriptServer.events.handleEvents.getWhileDisabled(() -> this.expr.executeAndEvaluate(context, Vanilla.ScriptServer_scriptOptimizations(scriptServer.server), host.loadOverrides, Vanilla.ScriptServer_scriptDebugging(scriptServer.server) ? arg_0 -> ((Logger)CarpetScriptServer.LOG).info(arg_0) : null));
        }
        catch (ExpressionException e) {
            throw new CarpetExpressionException(e.getMessage(), e.stack);
        }
        catch (ArithmeticException ae) {
            throw new CarpetExpressionException("Math doesn't compute... " + ae.getMessage(), null);
        }
        catch (StackOverflowError soe) {
            throw new CarpetExpressionException("Your thoughts are too deep", null);
        }
    }

    public List<Token> explain(ScriptHost host, @Nullable String code, @Nullable String method, @Nullable String style, class_2338 pos) {
        CarpetScriptServer scriptServer = (CarpetScriptServer)host.scriptServer();
        try {
            Context context = new CarpetContext(host, this.source, this.origin).with("x", (c, t) -> new NumericValue(pos.method_10263() - this.origin.method_10263()).bindTo("x")).with("y", (c, t) -> new NumericValue(pos.method_10264() - this.origin.method_10264()).bindTo("y")).with("z", (c, t) -> new NumericValue(pos.method_10260() - this.origin.method_10260()).bindTo("z"));
            class_1297 e = this.source.method_9228();
            if (e == null) {
                Value nullPlayer = Value.NULL.reboundedTo("p");
                context.with("p", (cc, tt) -> nullPlayer);
            } else {
                Value playerValue = new EntityValue(e).bindTo("p");
                context.with("p", (cc, tt) -> playerValue);
            }
            return scriptServer.events.handleEvents.getWhileDisabled(() -> this.expr.explain(context, code, method, style));
        }
        catch (ExpressionException e) {
            throw new CarpetExpressionException(e.getMessage(), e.stack);
        }
        catch (ArithmeticException ae) {
            throw new CarpetExpressionException("Math doesn't compute... " + ae.getMessage(), null);
        }
        catch (StackOverflowError soe) {
            throw new CarpetExpressionException("Your thoughts are too deep", null);
        }
    }
}

