/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Reference;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.FeatureSet;
import ch.endte.syncmatica.communication.exchange.FeatureExchange;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.litematica.LitematicManager;
import ch.endte.syncmatica.network.PacketType;
import io.netty.buffer.Unpooled;
import net.minecraft.class_2540;

public class VersionHandshakeClient
extends FeatureExchange {
    private String partnerVersion;

    public VersionHandshakeClient(ExchangeTarget partner, Context con) {
        super(partner, con);
    }

    @Override
    public boolean checkPacket(PacketType type, class_2540 packetBuf) {
        return type.equals((Object)PacketType.CONFIRM_USER) || type.equals((Object)PacketType.REGISTER_VERSION) || super.checkPacket(type, packetBuf);
    }

    @Override
    public void handle(PacketType type, class_2540 packetBuf) {
        if (type.equals((Object)PacketType.REGISTER_VERSION)) {
            String version = packetBuf.method_10800(this.PACKET_MAX_STRING_SIZE);
            if (!this.getContext().checkPartnerVersion(version)) {
                Syncmatica.LOGGER.warn("Denying syncmatica join due to outdated server with local version {} and server version {}", (Object)Reference.MOD_VERSION, (Object)version);
                this.close(false);
            } else {
                Syncmatica.LOGGER.info("Accepting version {} from partner {}", (Object)version, (Object)this.getPartner().getPersistentName());
                this.partnerVersion = version;
                FeatureSet fs = FeatureSet.fromVersionString(version);
                if (fs == null) {
                    this.requestFeatureSet();
                } else {
                    this.getPartner().setFeatureSet(fs);
                    this.onFeatureSetReceive();
                }
            }
        } else if (type.equals((Object)PacketType.CONFIRM_USER)) {
            int placementCount = packetBuf.readInt();
            for (int i = 0; i < placementCount; ++i) {
                ServerPlacement p = this.getManager().receiveMetaData(packetBuf, this.getPartner());
                this.getContext().getSyncmaticManager().addPlacement(p);
            }
            Syncmatica.LOGGER.info("Joining syncmatica server with local version {}", (Object)Reference.MOD_VERSION);
            LitematicManager.getInstance().commitLoad();
            this.getContext().startup();
            this.succeed();
        } else {
            super.handle(type, packetBuf);
        }
    }

    @Override
    public void onFeatureSetReceive() {
        class_2540 newBuf = new class_2540(Unpooled.buffer());
        newBuf.method_10814(Reference.MOD_VERSION);
        this.getPartner().sendPacket(PacketType.REGISTER_VERSION, newBuf, this.getContext());
    }

    @Override
    public void init() {
    }
}

