/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Reference;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.FeatureSet;
import ch.endte.syncmatica.communication.exchange.FeatureExchange;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.network.PacketType;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import net.minecraft.class_2540;

public class VersionHandshakeServer
extends FeatureExchange {
    private String partnerVersion;

    public VersionHandshakeServer(ExchangeTarget partner, Context con) {
        super(partner, con);
    }

    @Override
    public boolean checkPacket(PacketType type, class_2540 packetBuf) {
        return type.equals((Object)PacketType.REGISTER_VERSION) || super.checkPacket(type, packetBuf);
    }

    @Override
    public void handle(PacketType type, class_2540 packetBuf) {
        if (type.equals((Object)PacketType.REGISTER_VERSION)) {
            this.partnerVersion = packetBuf.method_10800(this.PACKET_MAX_STRING_SIZE);
            if (!this.getContext().checkPartnerVersion(this.partnerVersion)) {
                Syncmatica.LOGGER.warn("Denying syncmatica join due to outdated client with local version {} and client version {} from partner {}", (Object)Reference.MOD_VERSION, (Object)this.partnerVersion, (Object)this.getPartner().getPersistentName());
                this.close(false);
                return;
            }
            FeatureSet fs = FeatureSet.fromVersionString(this.partnerVersion);
            if (fs == null) {
                this.requestFeatureSet();
            } else {
                this.getPartner().setFeatureSet(fs);
                this.onFeatureSetReceive();
            }
        } else {
            super.handle(type, packetBuf);
        }
    }

    @Override
    public void onFeatureSetReceive() {
        Syncmatica.LOGGER.info("Syncmatica client joining with local version {} and client version {}", (Object)Reference.MOD_VERSION, (Object)this.partnerVersion);
        class_2540 newBuf = new class_2540(Unpooled.buffer());
        Collection<ServerPlacement> l = this.getContext().getSyncmaticManager().getAll();
        newBuf.method_53002(l.size());
        for (ServerPlacement p : l) {
            this.getManager().putMetaData(p, newBuf, this.getPartner());
        }
        this.getPartner().sendPacket(PacketType.CONFIRM_USER, newBuf, this.getContext());
        this.succeed();
    }

    @Override
    public void init() {
        class_2540 newBuf = new class_2540(Unpooled.buffer());
        newBuf.method_10814(Reference.MOD_VERSION);
        this.getPartner().sendPacket(PacketType.REGISTER_VERSION, newBuf, this.getContext());
    }
}

