/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.data;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.data.IFileStorage;
import ch.endte.syncmatica.data.LocalLitematicState;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.UUID;

public class FileStorage
implements IFileStorage {
    private final HashMap<ServerPlacement, Long> buffer = new HashMap();
    private Context context = null;

    @Override
    public void setContext(Context con) {
        if (this.context != null) {
            throw new Context.DuplicateContextAssignmentException("Duplicate Context assignment");
        }
        this.context = con;
    }

    @Override
    public LocalLitematicState getLocalState(ServerPlacement placement) {
        Path localFile = this.getSchematicPath(placement);
        if (Files.isRegularFile(localFile, new LinkOption[0])) {
            if (this.isDownloading(placement)) {
                return LocalLitematicState.DOWNLOADING_LITEMATIC;
            }
            if (this.buffer.containsKey(placement) && this.buffer.get(placement).longValue() == this.getLastModified(localFile) || this.hashCompare(localFile, placement)) {
                return LocalLitematicState.LOCAL_LITEMATIC_PRESENT;
            }
            return LocalLitematicState.LOCAL_LITEMATIC_DESYNC;
        }
        return LocalLitematicState.NO_LOCAL_LITEMATIC;
    }

    private long getLastModified(Path file) {
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                Syncmatica.LOGGER.warn("Error getting last modified time of file '{}'; Exception: {}", (Object)file.getFileName().toString(), (Object)e.getLocalizedMessage());
            }
        }
        return System.currentTimeMillis();
    }

    private boolean isDownloading(ServerPlacement placement) {
        if (this.context == null) {
            throw new RuntimeException("No CommunicationManager has been set yet - cannot get litematic state");
        }
        return this.context.getCommunicationManager().getDownloadState(placement);
    }

    @Override
    public Path getLocalLitematic(ServerPlacement placement) {
        if (this.getLocalState(placement).isLocalFileReady()) {
            return this.getSchematicPath(placement);
        }
        return null;
    }

    @Override
    public Path createLocalLitematic(ServerPlacement placement) {
        if (this.getLocalState(placement).isLocalFileReady()) {
            throw new IllegalArgumentException("");
        }
        Path file = this.getSchematicPath(placement);
        try {
            if (Files.exists(file, new LinkOption[0])) {
                Files.deleteIfExists(file);
            }
            Files.createFile(file, new FileAttribute[0]);
            return file;
        }
        catch (IOException e) {
            Syncmatica.LOGGER.error("Exception creating new file: '{}'; Exception: {}", (Object)file.getFileName().toString(), (Object)e.getLocalizedMessage());
            return file;
        }
    }

    private boolean hashCompare(Path localFile, ServerPlacement placement) {
        UUID hash = null;
        try {
            hash = SyncmaticaUtil.createChecksum(new FileInputStream(localFile.toFile()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (hash == null) {
            return false;
        }
        if (hash.equals(placement.getHash())) {
            this.buffer.put(placement, this.getLastModified(localFile));
            return true;
        }
        return false;
    }

    private Path getSchematicPath(ServerPlacement placement) {
        Path litematicPath = this.context.getLitematicFolder();
        if (this.context.isServer()) {
            return litematicPath.resolve(placement.getHash().toString() + ".litematic");
        }
        String fileName = SyncmaticaUtil.sanitizeUnicodeFileName(placement.getNormalFileName());
        Syncmatica.debug("getSchematicPath(): Placement filename: '{}'", fileName);
        if (fileName.endsWith(".litematic")) {
            return litematicPath.resolve(fileName);
        }
        return litematicPath.resolve(fileName + ".litematic");
    }
}

