/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.extended_core;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.ServerCommunicationManager;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class PlayerIdentifierProvider {
    private final Map<UUID, PlayerIdentifier> identifiers = new HashMap<UUID, PlayerIdentifier>();
    private final Context context;

    public PlayerIdentifierProvider(Context context) {
        this.context = context;
        this.identifiers.put(PlayerIdentifier.MISSING_PLAYER_UUID, PlayerIdentifier.MISSING_PLAYER);
    }

    public PlayerIdentifier createOrGet(ExchangeTarget exchangeTarget) {
        ServerCommunicationManager profileProvider = (ServerCommunicationManager)this.context.getCommunicationManager();
        return this.createOrGet(profileProvider.getGameProfile(exchangeTarget));
    }

    public PlayerIdentifier createOrGet(GameProfile gameProfile) {
        return this.createOrGet(gameProfile.id(), gameProfile.name());
    }

    public PlayerIdentifier createOrGet(UUID uuid, String playerName) {
        PlayerIdentifier playerIdentifier = this.identifiers.computeIfAbsent(uuid, id -> new PlayerIdentifier(uuid, playerName));
        if (!this.context.isServer()) {
            playerIdentifier.updatePlayerName(playerName);
        }
        return playerIdentifier;
    }

    public void updateName(UUID uuid, String playerName) {
        this.createOrGet(uuid, playerName).updatePlayerName(playerName);
    }

    public PlayerIdentifier fromJson(JsonObject obj) {
        if (!obj.has("uuid") || !obj.has("name")) {
            return PlayerIdentifier.MISSING_PLAYER;
        }
        UUID jsonUUID = UUID.fromString(obj.get("uuid").getAsString());
        return this.identifiers.computeIfAbsent(jsonUUID, key -> new PlayerIdentifier(jsonUUID, obj.get("name").getAsString()));
    }
}

