/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica.gui;

import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.data.ServerPosition;
import ch.endte.syncmatica.litematica.LitematicManager;
import ch.endte.syncmatica.litematica.ScreenHelper;
import ch.endte.syncmatica.litematica.gui.GuiSyncmaticaServerPlacementList;
import ch.endte.syncmatica.litematica.gui.WidgetSyncmaticaServerPlacementEntry;
import ch.endte.syncmatica.litematica.schematic.Schema;
import ch.endte.syncmatica.litematica.schematic.SchematicSchema;
import ch.endte.syncmatica.util.SyncmaticaUtil;
import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.gui.Icons;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListBase;
import fi.dy.masa.malilib.gui.widgets.WidgetSearchBar;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_332;

public class WidgetListSyncmaticaServerPlacement
extends WidgetListBase<ServerPlacement, WidgetSyncmaticaServerPlacementEntry> {
    private final int infoWidth;
    private final int infoHeight;
    private final GuiSyncmaticaServerPlacementList parent;

    public WidgetListSyncmaticaServerPlacement(int x, int y, int width, int height, GuiSyncmaticaServerPlacementList parent, ISelectionListener<ServerPlacement> selectionListener) {
        super(x, y, width, height, selectionListener);
        this.browserEntryHeight = 22;
        this.infoWidth = 170;
        this.infoHeight = 290;
        this.widgetSearchBar = new WidgetSearchBar(x + 2, y + 4, width - 14, 14, 0, (IGuiIcon)Icons.FILE_ICON_SEARCH, LeftRight.LEFT);
        this.browserEntriesOffsetY = this.widgetSearchBar.getHeight() + 3;
        this.parent = parent;
        this.setSize(width, height);
        ScreenHelper.ifPresent(s -> s.setCurrentGui((GuiBase)parent));
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.browserWidth = this.getBrowserWidthForTotalWidth(width);
        this.browserEntryWidth = this.browserWidth - 14;
    }

    protected int getBrowserWidthForTotalWidth(int width) {
        return width - 6 - this.infoWidth;
    }

    public void drawContents(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        RenderUtils.drawOutlinedBox((class_332)drawContext, (int)this.posX, (int)this.posY, (int)this.browserWidth, (int)this.browserHeight, (int)-1342177280, (int)-6710887);
        super.drawContents(drawContext, mouseX, mouseY, partialTicks);
        this.drawPlacementInfo(drawContext, (ServerPlacement)this.getLastSelectedEntry());
    }

    private void drawPlacementInfo(class_332 drawContext, ServerPlacement placement) {
        int x = this.posX + this.totalWidth - this.infoWidth;
        int y = this.posY;
        int height = Math.min(this.infoHeight, this.parent.getMaxInfoHeight());
        RenderUtils.drawOutlinedBox((class_332)drawContext, (int)x, (int)y, (int)this.infoWidth, (int)height, (int)-1610612736, (int)-6710887);
        if (placement == null) {
            return;
        }
        int textColor = -1061109568;
        int valueColor = -1;
        String str = StringUtils.translate((String)"syncmatica.gui.label.placement_info.display_name", (Object[])new Object[0]);
        this.drawString(drawContext, str, x += 3, y += 3, -1061109568);
        this.drawString(drawContext, placement.getName(), x + 4, y += 12, -1);
        str = StringUtils.translate((String)"syncmatica.gui.label.placement_info.file_name", (Object[])new Object[0]);
        this.drawString(drawContext, str, x, y += 12, -1061109568);
        this.drawString(drawContext, placement.getFile().getFileName().toString(), x + 4, y += 12, -1);
        str = StringUtils.translate((String)"syncmatica.gui.label.placement_info.dimension_id", (Object[])new Object[0]);
        this.drawString(drawContext, str, x, y += 12, -1061109568);
        this.drawString(drawContext, placement.getDimension(), x + 4, y += 12, -1);
        str = StringUtils.translate((String)"syncmatica.gui.label.placement_info.position", (Object[])new Object[0]);
        this.drawString(drawContext, str, x, y += 12, -1061109568);
        class_2338 origin = placement.getPosition();
        String tmp = String.format("%d %d %d", origin.method_10263(), origin.method_10264(), origin.method_10260());
        this.drawString(drawContext, tmp, x + 4, y += 12, -1);
        str = StringUtils.translate((String)"syncmatica.gui.label.placement_info.owner", (Object[])new Object[0]);
        this.drawString(drawContext, str, x, y += 12, -1061109568);
        this.drawString(drawContext, placement.getOwner().getName(), x + 4, y += 12, -1);
        str = StringUtils.translate((String)"syncmatica.gui.label.placement_info.last_modified", (Object[])new Object[0]);
        this.drawString(drawContext, str, x, y += 12, -1061109568);
        this.drawString(drawContext, placement.getLastModifiedBy().getName(), x + 4, y += 12, -1);
        y += 12;
        int litematic = placement.getLitematicVersion();
        int dataVersion = placement.getDataVersion();
        if (litematic > -1 && dataVersion > -1) {
            SchematicSchema version = new SchematicSchema(litematic, dataVersion);
            Schema schema = Schema.getSchemaByDataVersion(dataVersion);
            str = StringUtils.translate((String)"syncmatica.gui.label.placement_info.version", (Object[])new Object[]{version.litematicVersion()});
            this.drawString(drawContext, str, x, y, -1061109568);
            y += 12;
            if (schema != null) {
                str = StringUtils.translate((String)"syncmatica.gui.label.placement_info.schema", (Object[])new Object[]{schema.getString(), version.minecraftDataVersion()});
                this.drawString(drawContext, str, x, y, -1061109568);
            }
        }
    }

    protected List<String> getEntryStringsForFilter(ServerPlacement entry) {
        String metaName = entry.getName().toLowerCase();
        return ImmutableList.of((Object)metaName);
    }

    protected WidgetSyncmaticaServerPlacementEntry createListEntryWidget(int x, int y, int listIndex, boolean isOdd, ServerPlacement entry) {
        return new WidgetSyncmaticaServerPlacementEntry(x, y, this.browserEntryWidth, this.getBrowserEntryHeightFor(entry), entry, listIndex);
    }

    protected Collection<ServerPlacement> getAllEntries() {
        ServerPosition playerPosition = LitematicManager.getInstance().getPlayerPosition();
        Collection<ServerPlacement> serverPlacements = LitematicManager.getInstance().getActiveContext().getSyncmaticManager().getAll();
        return serverPlacements.stream().sorted(new PlayerDistanceComparator(playerPosition)).collect(Collectors.toList());
    }

    public static class PlayerDistanceComparator
    implements Comparator<ServerPlacement> {
        private final String playerDimension;
        private final class_2338 playerPosition;
        private final class_2338 playerPositionOverworld;
        private final class_2338 playerPositionNether;

        PlayerDistanceComparator(ServerPosition playerPosition) {
            this.playerPosition = playerPosition.getBlockPosition();
            this.playerDimension = playerPosition.getDimensionId();
            this.playerPositionNether = playerPosition.getDimensionId().equals("minecraft:overworld") ? new class_2338(this.playerPosition.method_10263() << 3, this.playerPosition.method_10264() << 3, this.playerPosition.method_10260() << 3) : this.playerPosition;
            this.playerPositionOverworld = playerPosition.getDimensionId().equals("minecraft:the_nether") ? new class_2338(this.playerPosition.method_10263() >> 3, this.playerPosition.method_10264() >> 3, this.playerPosition.method_10260() >> 3) : this.playerPosition;
        }

        @Override
        public int compare(ServerPlacement serverPlacement1, ServerPlacement serverPlacement2) {
            boolean linkedDimensions2;
            boolean equalDimension2;
            String dimension1 = serverPlacement1.getDimension();
            String dimension2 = serverPlacement2.getDimension();
            boolean equalDimension1 = this.compareDimensions(dimension1, this.playerDimension);
            if (equalDimension1 ^ (equalDimension2 = this.compareDimensions(dimension2, this.playerDimension))) {
                return equalDimension1 ? -1 : 1;
            }
            boolean linkedDimensions1 = this.areInLinkedDimensions(dimension1, this.playerDimension);
            if (linkedDimensions1 ^ (linkedDimensions2 = this.areInLinkedDimensions(dimension2, this.playerDimension))) {
                return linkedDimensions1 ? -1 : 1;
            }
            return Double.compare(this.getDimensionDistanceSquared(serverPlacement1.getOrigin()), this.getDimensionDistanceSquared(serverPlacement2.getOrigin()));
        }

        private double getDimensionDistanceSquared(ServerPosition position) {
            if (position.getDimensionId().equals("minecraft:overworld")) {
                return SyncmaticaUtil.getBlockDistanceSquared(position.getBlockPosition(), this.playerPositionOverworld.method_10263(), this.playerPositionOverworld.method_10264(), this.playerPositionOverworld.method_10260());
            }
            if (position.getDimensionId().equals("minecraft:the_nether")) {
                return SyncmaticaUtil.getBlockDistanceSquared(position.getBlockPosition(), this.playerPositionNether.method_10263(), this.playerPositionNether.method_10264(), this.playerPositionNether.method_10260());
            }
            return SyncmaticaUtil.getBlockDistanceSquared(position.getBlockPosition(), this.playerPosition.method_10263(), this.playerPosition.method_10264(), this.playerPosition.method_10260());
        }

        private boolean compareDimensions(String dimensionId1, String dimensionId2) {
            return dimensionId1.equals(dimensionId2);
        }

        private boolean areInLinkedDimensions(String dimension1, String dimension2) {
            return this.isOverworld(dimension1) && this.isNether(dimension2) || this.isNether(dimension1) && this.isOverworld(dimension2);
        }

        private boolean isNether(String dimensionId) {
            return dimensionId.equals("minecraft:the_nether");
        }

        private boolean isOverworld(String dimensionId) {
            return dimensionId.equals("minecraft:overworld");
        }
    }
}

