/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.litematica_mixin;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.Feature;
import ch.endte.syncmatica.communication.ClientCommunicationManager;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.exchange.ModifyExchangeClient;
import ch.endte.syncmatica.data.ServerPlacement;
import ch.endte.syncmatica.litematica.LitematicManager;
import ch.endte.syncmatica.litematica.ScreenHelper;
import ch.endte.syncmatica.litematica.gui.IGuiBase;
import fi.dy.masa.litematica.gui.GuiPlacementConfiguration;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import java.util.List;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiPlacementConfiguration.class})
public abstract class MixinGuiPlacementConfiguration
extends GuiBase {
    @Final
    @Shadow(remap=false)
    public SchematicPlacement placement;

    @Inject(method={"initGui"}, at={@At(value="RETURN")}, remap=false)
    public void initGui(CallbackInfo ci) {
        if (!LitematicManager.getInstance().isSyncmatic(this.placement)) {
            return;
        }
        List<ButtonBase> buttons = ((IGuiBase)((Object)this)).getButtons();
        ButtonBase button = buttons.get(6);
        button.setActionListener((b, k) -> {
            if (this.placement.isLocked()) {
                this.requestModification();
            } else {
                this.finishModification();
            }
        });
        ScreenHelper.ifPresent(s -> s.setCurrentGui(this));
    }

    @Unique
    private void requestModification() {
        Context context = LitematicManager.getInstance().getActiveContext();
        ExchangeTarget server = ((ClientCommunicationManager)context.getCommunicationManager()).getServer();
        ServerPlacement serverPlacement = LitematicManager.getInstance().syncmaticFromSchematic(this.placement);
        if (!server.getFeatureSet().hasFeature(Feature.CORE_EX) && this.placement.isRegionPlacementModified()) {
            this.addMessage(Message.MessageType.ERROR, "syncmatica.error.share_modified_subregions", new Object[0]);
            return;
        }
        ModifyExchangeClient modifyExchange = new ModifyExchangeClient(serverPlacement, server, context);
        context.getCommunicationManager().startExchange(modifyExchange);
    }

    @Unique
    private void finishModification() {
        Context context = LitematicManager.getInstance().getActiveContext();
        ExchangeTarget server = ((ClientCommunicationManager)context.getCommunicationManager()).getServer();
        if (!server.getFeatureSet().hasFeature(Feature.CORE_EX) && this.placement.isRegionPlacementModified()) {
            this.addMessage(Message.MessageType.ERROR, "syncmatica.error.share_modified_subregions", new Object[0]);
            return;
        }
        ServerPlacement serverPlacement = LitematicManager.getInstance().syncmaticFromSchematic(this.placement);
        ModifyExchangeClient modifyExchange = (ModifyExchangeClient)context.getCommunicationManager().getModifier(serverPlacement);
        if (modifyExchange != null) {
            modifyExchange.conclude();
        }
    }
}

