/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.material;

import ch.endte.syncmatica.data.ServerPosition;
import ch.endte.syncmatica.material.DeliveryPosition;
import ch.endte.syncmatica.material.SyncmaticaMaterialEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class SyncmaticaMaterialList {
    private ArrayList<SyncmaticaMaterialEntry> list;
    private ServerPosition deliveryPoint;

    public SyncmaticaMaterialEntry getUnclaimedEntry() {
        Optional<SyncmaticaMaterialEntry> unclaimed = this.list.parallelStream().filter(SyncmaticaMaterialEntry.UNFINISHED).filter(SyncmaticaMaterialEntry.UNCLAIMED).findFirst();
        if (unclaimed.isPresent()) {
            return unclaimed.get();
        }
        return null;
    }

    public Collection<DeliveryPosition> getDeliveryPosition(SyncmaticaMaterialEntry entry) {
        if (!this.list.contains(entry)) {
            throw new IllegalArgumentException();
        }
        DeliveryPosition delivery = new DeliveryPosition(this.deliveryPoint.getBlockPosition(), this.deliveryPoint.getDimensionId(), entry.getAmountMissing());
        ArrayList<DeliveryPosition> deliveryList = new ArrayList<DeliveryPosition>();
        deliveryList.add(delivery);
        return deliveryList;
    }
}

