/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.service;

import ch.endte.syncmatica.Syncmatica;
import ch.endte.syncmatica.network.PacketType;
import ch.endte.syncmatica.service.AbstractService;
import ch.endte.syncmatica.service.IServiceConfiguration;

public class DebugService
extends AbstractService {
    private boolean doPacketLogging = true;

    public void logReceivePacket(PacketType packetType) {
        if (this.doPacketLogging) {
            Syncmatica.LOGGER.info("Syncmatica - received packet:[type={}]", (Object)packetType.toString());
        }
    }

    public void logSendPacket(PacketType packetType, String targetIdentifier) {
        if (this.doPacketLogging) {
            Syncmatica.LOGGER.info("Sending packet[type={}] to ExchangeTarget[id={}]", (Object)packetType.toString(), (Object)targetIdentifier);
        }
    }

    @Override
    public void getDefaultConfiguration(IServiceConfiguration configuration) {
        configuration.saveBoolean("doPackageLogging", false);
    }

    @Override
    public String getConfigKey() {
        return "debug";
    }

    @Override
    public void configure(IServiceConfiguration configuration) {
        configuration.loadBoolean("doPackageLogging", b -> {
            this.doPacketLogging = b;
        });
    }

    @Override
    public void startup() {
    }

    @Override
    public void shutdown() {
    }
}

