/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2791;
import net.minecraft.class_2818;

public abstract class OverlayRendererBase
implements IOverlayRenderer {
    protected final List<RenderObjectVbo> renderObjects = new ArrayList<RenderObjectVbo>();
    protected boolean renderThrough = false;
    protected boolean useCulling = false;
    protected float glLineWidth = 1.0f;
    @Nullable
    protected class_2338 lastUpdatePos = class_2338.field_10980;
    private class_243 updateCameraPos = class_243.field_1353;
    protected boolean shouldResort = false;

    protected void clearBuffers() {
        if (!this.renderObjects.isEmpty()) {
            this.resetBuffers();
            this.renderObjects.clear();
        }
    }

    protected void allocateBuffers() {
        this.allocateBuffers(true);
    }

    protected void allocateBuffers(boolean useOutlines) {
        this.clearBuffers();
        this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + "/Quads", MaLiLibPipelines.MINIHUD_SHAPE_OFFSET_NO_CULL));
        if (useOutlines) {
            this.renderObjects.add(new RenderObjectVbo(() -> this.getName() + "/Outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH));
        }
    }

    protected void resetBuffers() {
        this.renderObjects.forEach(RenderObjectVbo::reset);
    }

    @Override
    public final class_243 getUpdatePosition() {
        return this.updateCameraPos;
    }

    @Override
    public final void setUpdatePosition(class_243 cameraPosition) {
        this.updateCameraPos = cameraPosition;
    }

    protected int getTopYOverTerrain(class_1937 world, class_2338 pos, int range) {
        int minX = pos.method_10263() - range;
        int minZ = pos.method_10260() - range;
        int maxX = pos.method_10263() + range;
        int maxZ = pos.method_10260() + range;
        int minCX = minX >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCZ = maxZ >> 4;
        int maxY = 0;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                class_2818 chunk = world.method_8497(cx, cz);
                int height = WorldUtils.getHighestSectionYOffset((class_2791)chunk) + 15;
                if (height <= maxY) continue;
                maxY = height;
            }
        }
        return maxY + 4;
    }

    @Override
    public void draw(class_243 cameraPos) {
        for (RenderObjectVbo obj : this.renderObjects) {
            if (!obj.isStarted() || !obj.isUploaded()) continue;
            if (this.shouldResort && obj.shouldResort()) {
                obj.resortTranslucent(obj.createVertexSorter(cameraPos));
            }
            if (obj.getDrawMode() == VertexFormat.class_5596.field_27377 || obj.getDrawMode() == VertexFormat.class_5596.field_29344) {
                obj.lineWidth(this.glLineWidth);
                obj.drawPost(null, false, true);
                continue;
            }
            obj.drawPost(null, false, false);
        }
    }

    @Override
    public void reset() {
        this.resetBuffers();
        this.glLineWidth = 1.0f;
        this.lastUpdatePos = class_2338.field_10980;
        this.updateCameraPos = class_243.field_1353;
    }

    public void setRenderThrough(boolean renderThrough) {
        this.renderThrough = renderThrough;
    }

    public String getSaveId() {
        return "";
    }

    @Nullable
    public JsonObject toJson() {
        return null;
    }

    public void fromJson(JsonObject obj) {
    }
}

