/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.client.gui.state;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_1923;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

public final class ColoredChunkDataRenderState
extends Record
implements class_11244 {
    private final RenderPipeline pipeline;
    private final class_11231 textureSetup;
    private final Matrix3x2f pose;
    private final Int2ObjectMap<List<class_1923>> chunks;
    @Nullable
    private final class_8030 scissorArea;
    @Nullable
    private final class_8030 bounds;

    public ColoredChunkDataRenderState(RenderPipeline pipeline, class_11231 textureSetup, Matrix3x2f pose, Int2ObjectMap<List<class_1923>> chunks, @Nullable class_8030 scissorArea) {
        this(pipeline, textureSetup, pose, chunks, scissorArea, ColoredChunkDataRenderState.getBounds(chunks, pose, scissorArea));
    }

    public ColoredChunkDataRenderState(RenderPipeline pipeline, class_11231 textureSetup, Matrix3x2f pose, Int2ObjectMap<List<class_1923>> chunks, @Nullable class_8030 scissorArea, @Nullable class_8030 bounds) {
        this.pipeline = pipeline;
        this.textureSetup = textureSetup;
        this.pose = pose;
        this.chunks = chunks;
        this.scissorArea = scissorArea;
        this.bounds = bounds;
    }

    public void method_70917(class_4588 vertexConsumer) {
        for (Int2ObjectMap.Entry chunks : this.chunks.int2ObjectEntrySet()) {
            int color = chunks.getIntKey();
            for (class_1923 pos : (List)chunks.getValue()) {
                int minX = pos.field_9181;
                int maxX = minX + 1;
                int minY = pos.field_9180;
                int maxY = minY + 1;
                vertexConsumer.method_70815(this.pose, (float)minX, (float)minY).method_39415(color);
                vertexConsumer.method_70815(this.pose, (float)minX, (float)maxY).method_39415(color);
                vertexConsumer.method_70815(this.pose, (float)maxX, (float)maxY).method_39415(color);
                vertexConsumer.method_70815(this.pose, (float)maxX, (float)minY).method_39415(color);
            }
        }
    }

    @Nullable
    private static class_8030 getBounds(Int2ObjectMap<List<class_1923>> chunks, Matrix3x2f pose, @Nullable class_8030 scissor) {
        if (chunks.isEmpty()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (List entry : chunks.values()) {
            for (class_1923 pos : entry) {
                minX = Math.min(minX, pos.field_9181);
                maxX = Math.max(maxX, pos.field_9181);
                minY = Math.min(minY, pos.field_9181);
                maxY = Math.max(maxY, pos.field_9181);
            }
        }
        class_8030 bounds = new class_8030(minX, minY, maxX - minX, maxY - minY).method_71523(pose);
        return scissor != null ? scissor.method_49701(bounds) : bounds;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ColoredChunkDataRenderState.class, "pipeline;textureSetup;pose;chunks;scissorArea;bounds", "pipeline", "textureSetup", "pose", "chunks", "scissorArea", "bounds"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ColoredChunkDataRenderState.class, "pipeline;textureSetup;pose;chunks;scissorArea;bounds", "pipeline", "textureSetup", "pose", "chunks", "scissorArea", "bounds"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ColoredChunkDataRenderState.class, "pipeline;textureSetup;pose;chunks;scissorArea;bounds", "pipeline", "textureSetup", "pose", "chunks", "scissorArea", "bounds"}, this, o);
    }

    public RenderPipeline comp_4055() {
        return this.pipeline;
    }

    public class_11231 comp_4056() {
        return this.textureSetup;
    }

    public Matrix3x2f pose() {
        return this.pose;
    }

    public Int2ObjectMap<List<class_1923>> chunks() {
        return this.chunks;
    }

    @Nullable
    public class_8030 comp_4069() {
        return this.scissorArea;
    }

    @Nullable
    public class_8030 comp_4274() {
        return this.bounds;
    }
}

