/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.common.utils;

import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Optional;
import me.senseiwells.chunkdebug.server.mixins.TicketAccessor;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ExtraStreamCodecs {
    private static final class_2960 UNREGISTERED = class_2960.method_60655((String)"chunk-debug", (String)"unregistered");
    public static final class_9139<class_9129, class_5321<class_1937>> DIMENSION = class_9139.method_56437(ExtraStreamCodecs::encodeDimension, ExtraStreamCodecs::decodeDimension);
    public static final class_9139<class_9129, List<class_5321<class_1937>>> DIMENSIONS = class_9135.method_56363().apply(DIMENSION);
    public static final class_9139<class_9129, class_6880<class_2806>> CHUNK_STATUS = class_9135.method_56383((class_5321)class_7924.field_41261);
    public static final class_9139<class_9129, Optional<class_6880<class_2806>>> OPTIONAL_CHUNK_STATUS = class_9135.method_56382(CHUNK_STATUS);
    public static final class_9139<class_2540, class_3228> TICKET = class_9139.method_56437(ExtraStreamCodecs::encodeTicket, ExtraStreamCodecs::decodeTicket);
    public static final class_9139<class_2540, List<class_3228>> TICKETS = class_9135.method_56363().apply(TICKET);
    private static final HashBiMap<class_3230, class_2960> CUSTOM_TICKET_TYPES = HashBiMap.create();

    public static String getTicketTypeAsString(class_3230 type) {
        class_2960 location = (class_2960)CUSTOM_TICKET_TYPES.get((Object)type);
        if (location != null) {
            return location.toString();
        }
        return class_156.method_57107((class_2378)class_7923.field_55881, (Object)type);
    }

    private static void encodeDimension(class_9129 buf, class_5321<class_1937> dimension) {
        buf.method_44116(dimension);
    }

    private static class_5321<class_1937> decodeDimension(class_9129 buf) {
        return buf.method_44112(class_7924.field_41223);
    }

    private static void encodeTicket(class_2540 buf, class_3228 ticket) {
        class_2960 location = class_7923.field_55881.method_10221((Object)ticket.method_14281());
        if (location == null) {
            location = UNREGISTERED;
        }
        buf.method_10812(location);
        buf.method_53002((int)((TicketAccessor)ticket).getRemainingTicks());
        buf.method_53002(ticket.method_14283());
    }

    private static class_3228 decodeTicket(class_2540 buf) {
        class_3230 type;
        class_2960 location = buf.method_10810();
        Optional optional = class_7923.field_55881.method_17966(location);
        if (optional.isEmpty()) {
            type = (class_3230)CUSTOM_TICKET_TYPES.inverse().get((Object)location);
            if (type == null) {
                type = new class_3230(0L, 3);
                CUSTOM_TICKET_TYPES.put((Object)type, (Object)location);
            }
        } else {
            type = (class_3230)optional.get();
        }
        int ticksRemaining = buf.readInt();
        int ticketLevel = buf.readInt();
        return TicketAccessor.construct(type, ticketLevel, ticksRemaining);
    }
}

