/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.chunkdebug.server.tracker;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.senseiwells.chunkdebug.common.utils.ChunkData;
import me.senseiwells.chunkdebug.server.holder.ChunkDataSupplier;
import me.senseiwells.chunkdebug.server.holder.ChunkHolderSupplier;
import me.senseiwells.chunkdebug.server.utils.LevelUtils;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3228;
import net.minecraft.class_3898;

public class ChunkDebugTracker {
    private final Long2ObjectMap<ChunkData> chunks = new Long2ObjectOpenHashMap();
    private final LongSet dirty = new LongOpenHashSet();
    private final Long2ObjectMap<class_2806> stages = new Long2ObjectOpenHashMap();
    private final class_3218 level;

    public ChunkDebugTracker(class_3218 level) {
        this.level = level;
    }

    public Collection<ChunkData> getChunks() {
        this.checkSameThread();
        return this.chunks.values();
    }

    public DirtyChunks getDirtyChunks() {
        this.checkSameThread();
        ArrayList<ChunkData> updated = new ArrayList<ChunkData>(this.dirty.size());
        LongArrayList removed = new LongArrayList();
        LongIterator iter = this.dirty.iterator();
        while (iter.hasNext()) {
            long pos = iter.nextLong();
            ChunkData data = (ChunkData)this.chunks.get(pos);
            if (data != null) {
                updated.add(data);
                continue;
            }
            removed.add(pos);
        }
        this.dirty.clear();
        return new DirtyChunks(updated, (LongList)removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Long2ObjectMap<class_2806> long2ObjectMap = this.stages;
        synchronized (long2ObjectMap) {
            for (Long2ObjectMap.Entry entry : this.stages.long2ObjectEntrySet()) {
                long pos = entry.getLongKey();
                ChunkData data = (ChunkData)this.chunks.get(pos);
                class_2806 stage = (class_2806)entry.getValue();
                if (data == null || data.stage() == stage) continue;
                data.updateStage(stage);
                this.markDirty(pos);
            }
            this.stages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.checkSameThread();
        this.chunks.clear();
        this.dirty.clear();
        Long2ObjectMap<class_2806> long2ObjectMap = this.stages;
        synchronized (long2ObjectMap) {
            this.stages.clear();
        }
        class_3898 chunkMap = this.level.method_14178().field_17254;
        ((ChunkHolderSupplier)chunkMap).chunkdebug$forEachChunkHolder(holder -> this.set(((ChunkDataSupplier)holder).chunkdebug$getChunkData(chunkMap)));
    }

    public void set(ChunkData data) {
        long pos = data.position().method_8324();
        if (this.markDirty(pos)) {
            this.chunks.put(pos, (Object)data);
        }
    }

    public void unload(long pos) {
        if (this.markDirty(pos)) {
            this.chunks.remove(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStage(long pos, class_2806 stage) {
        Long2ObjectMap<class_2806> long2ObjectMap = this.stages;
        synchronized (long2ObjectMap) {
            this.stages.put(pos, (Object)stage);
        }
    }

    public void updateTickets(long pos, List<class_3228> tickets) {
        ChunkData data = (ChunkData)this.chunks.get(pos);
        if (data != null) {
            data.updateTickets(tickets);
            this.markDirty(pos);
        }
    }

    public void updateTickingStatusLevel(long pos, int level) {
        ChunkData data = (ChunkData)this.chunks.get(pos);
        if (data != null) {
            data.updateTickingStatusLevel(level);
            this.markDirty(pos);
        }
    }

    public void updateUnloading(long pos, boolean unloading) {
        ChunkData data = (ChunkData)this.chunks.get(pos);
        if (data != null) {
            data.updateUnloading(unloading);
            this.markDirty(pos);
        }
    }

    private boolean markDirty(long pos) {
        if (!this.level.method_8503().method_3750()) {
            this.checkSameThread();
            this.dirty.add(pos);
            return true;
        }
        return false;
    }

    private void checkSameThread() {
        if (!LevelUtils.isSameThread(this.level)) {
            throw new IllegalStateException("Tried using ChunkDebugTracker off level thread");
        }
    }

    public record DirtyChunks(List<ChunkData> updated, LongList removed) {
    }
}

