/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.module.particle.trail;

import it.hurts.shatterbyte.shatterlib.module.particle.trail.TrailBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;

public class DefaultTrailBuffer<T>
implements TrailBuffer {
    private Deque<class_243> points = new ArrayDeque<class_243>();
    private final int maxSize;

    public DefaultTrailBuffer(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void write(class_243 vec3) {
        if (this.size() >= this.maxSize) {
            this.remove();
        }
        this.points.push(vec3);
    }

    @Override
    public int size() {
        return this.points.size();
    }

    @Override
    public void remove() {
        this.points.removeLast();
    }

    @Override
    @NotNull
    public Iterator<class_243> iterator() {
        return this.points.iterator();
    }

    public Deque<class_243> getPoints() {
        return this.points;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setPoints(Deque<class_243> points) {
        this.points = points;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultTrailBuffer)) {
            return false;
        }
        DefaultTrailBuffer other = (DefaultTrailBuffer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        Deque<class_243> this$points = this.getPoints();
        Deque<class_243> other$points = other.getPoints();
        return !(this$points == null ? other$points != null : !this$points.equals(other$points));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultTrailBuffer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxSize();
        Deque<class_243> $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : $points.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultTrailBuffer(points=" + String.valueOf(this.getPoints()) + ", maxSize=" + this.getMaxSize() + ")";
    }
}

