/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.module.particle.trail;

import it.hurts.shatterbyte.shatterlib.module.particle.RenderProvider;
import it.hurts.shatterbyte.shatterlib.module.particle.ShatterRenderManager;
import it.hurts.shatterbyte.shatterlib.module.particle.trail.DefaultTrailBuffer;
import it.hurts.shatterbyte.shatterlib.module.particle.trail.TrailBuffer;
import it.hurts.shatterbyte.shatterlib.util.ColorUtils;
import it.hurts.shatterbyte.shatterlib.util.TesselatorUtils;
import it.hurts.shatterbyte.shatterlib.util.VectorUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public abstract class TrailProvider
implements RenderProvider<TrailProvider, TrailBuffer> {
    @Override
    public TrailBuffer createBuffer() {
        return new DefaultTrailBuffer(this.getTrailMaxLength());
    }

    @Override
    public boolean shouldRender(TrailBuffer buffer) {
        return this.isTrailAlive() || !this.disappearAfterDeath() && buffer.size() != 0;
    }

    @Override
    public class_243 getRenderPosition(float partialTick) {
        return this.getTrailPosition(partialTick);
    }

    public abstract class_243 getTrailPosition(float var1);

    @Override
    @Deprecated
    public double getRenderDistance() {
        return this.getTrailRenderDistance();
    }

    public double getTrailRenderDistance() {
        return 64.0;
    }

    @Override
    @Deprecated
    public int getUpdateFrequency() {
        return this.getTrailUpdateFrequency();
    }

    public abstract int getTrailUpdateFrequency();

    public abstract boolean isTrailAlive();

    public boolean isTrailGrowing() {
        return true;
    }

    public boolean disappearAfterDeath() {
        return false;
    }

    public abstract int getTrailMaxLength();

    public abstract int getTrailFadeInColor();

    public abstract int getTrailFadeOutColor();

    public abstract double getTrailScale();

    public int getTrailInterpolationPoints() {
        return 1;
    }

    public List<class_243> getTrailRenderPositions(List<class_243> points, float pTicks) {
        return points;
    }

    @Override
    @Deprecated
    public void render(float pTicks, class_4587 poseStack, class_4588 consumer) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_243 matrixTranslation = this.getRenderPosition(pTicks);
        long time = world.method_8510();
        int segments = this.getTrailMaxLength();
        if (segments <= 0 || this.getTrailUpdateFrequency() <= 0) {
            return;
        }
        List<Object> partialPoses = new ArrayList<class_243>();
        float partial = (float)(time % (long)this.getTrailUpdateFrequency()) + pTicks;
        TrailBuffer buffer = (TrailBuffer)ShatterRenderManager.getOrCreateBuffer(this);
        if (buffer == null) {
            return;
        }
        List<class_243> points = new ArrayList<class_243>();
        if (this.isTrailAlive()) {
            points.add(new class_243(0.0, 0.0, 0.0));
        }
        for (class_243 vec3 : buffer) {
            points.add(vec3.method_1020(matrixTranslation));
        }
        if ((points = this.getTrailRenderPositions(points, pTicks)).size() > 2) {
            for (int i = 0; i < points.size() - 1; ++i) {
                class_243 p0 = i == 0 ? points.getFirst() : points.get(i - 1);
                class_243 p1 = points.get(i);
                class_243 p2 = points.get(i + 1);
                class_243 p3 = i == points.size() - 2 ? points.getLast() : points.get(i + 2);
                partialPoses.add(p1);
                int interpolationPoints = Math.max(1, this.getTrailInterpolationPoints() + 1);
                for (float f = 1.0f / (float)interpolationPoints; f < 1.0f; f += 1.0f / (float)interpolationPoints) {
                    partialPoses.add(VectorUtils.catmullromVec(f, p0, p1, p2, p3));
                }
            }
            partialPoses.add(points.getLast());
        } else {
            partialPoses.addAll(points);
        }
        if (points.size() > 1 && this.getTrailMaxLength() + 1 == points.size()) {
            int i = partialPoses.size() - 1;
            class_243 adjustment = ((class_243)partialPoses.get(i - 1)).method_1020((class_243)partialPoses.get(i)).method_1021((double)partial / (double)this.getTrailUpdateFrequency() * (double)this.getTrailInterpolationPoints());
            partialPoses.set(i, ((class_243)partialPoses.get(i)).method_1019(adjustment));
        }
        if (partialPoses.size() < 2) {
            return;
        }
        if ((partialPoses = partialPoses.stream().filter(Objects::nonNull).toList()).size() < 2) {
            return;
        }
        class_243[][] crossVecs = new class_243[partialPoses.size()][3];
        for (int i = 1; i < partialPoses.size(); ++i) {
            class_243 pos1 = (class_243)partialPoses.get(i - 1);
            class_243 pos2 = (class_243)partialPoses.get(i);
            if (pos1 == null || pos2 == null) continue;
            class_243 vec1 = pos2.method_1020(pos1);
            class_243 vec1n = vec1.method_1029();
            class_243 perpendicular1 = vec1n.method_1036(VectorUtils.Y_VEC).method_1029();
            double scale = this.getTrailScale() * (1.0 - (double)i / (double)(partialPoses.size() - 1)) + 0.005;
            crossVecs[i - 1][0] = perpendicular1.method_1021(scale);
            crossVecs[i - 1][1] = VectorUtils.rotate(crossVecs[i - 1][0], vec1n, 120.0);
            crossVecs[i - 1][2] = VectorUtils.rotate(crossVecs[i - 1][0], vec1n, -120.0);
        }
        Color color1 = new Color(this.getTrailFadeInColor(), true);
        Color color2 = new Color(this.getTrailFadeOutColor(), true);
        poseStack.method_22903();
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        for (int i = 0; i < partialPoses.size() - 1; ++i) {
            class_243 pos1 = (class_243)partialPoses.get(i);
            class_243 pos2 = (class_243)partialPoses.get(i + 1);
            if (pos1 == null || pos2 == null || crossVecs[i][0] == null || crossVecs[i][1] == null || crossVecs[i + 1][0] == null || crossVecs[i + 1][1] == null) continue;
            class_243 tip1 = pos1.method_1019(crossVecs[i][0]);
            class_243 base1Left = pos1.method_1019(crossVecs[i][2]);
            class_243 base1Right = pos1.method_1019(crossVecs[i][1]);
            class_243 tip2 = pos2.method_1019(crossVecs[i + 1][0]);
            class_243 base2Left = pos2.method_1019(crossVecs[i + 1][2]);
            class_243 base2Right = pos2.method_1019(crossVecs[i + 1][1]);
            Color c1 = ColorUtils.blend(color1, color2, (float)i / (float)(partialPoses.size() - 1));
            Color c2 = ColorUtils.blend(color1, color2, (float)(i + 1) / (float)(partialPoses.size() - 1));
            TesselatorUtils.drawQuadGradient(consumer, matrix4f, (float)base2Left.field_1352, (float)base2Left.field_1351, (float)base2Left.field_1350, (float)base1Left.field_1352, (float)base1Left.field_1351, (float)base1Left.field_1350, (float)tip1.field_1352, (float)tip1.field_1351, (float)tip1.field_1350, (float)tip2.field_1352, (float)tip2.field_1351, (float)tip2.field_1350, c2, c1);
            TesselatorUtils.drawQuadGradient(consumer, matrix4f, (float)tip2.field_1352, (float)tip2.field_1351, (float)tip2.field_1350, (float)tip1.field_1352, (float)tip1.field_1351, (float)tip1.field_1350, (float)base1Right.field_1352, (float)base1Right.field_1351, (float)base1Right.field_1350, (float)base2Right.field_1352, (float)base2Right.field_1351, (float)base2Right.field_1350, c2, c1);
            TesselatorUtils.drawQuadGradient(consumer, matrix4f, (float)base2Right.field_1352, (float)base2Right.field_1351, (float)base2Right.field_1350, (float)base1Right.field_1352, (float)base1Right.field_1351, (float)base1Right.field_1350, (float)base1Left.field_1352, (float)base1Left.field_1351, (float)base1Left.field_1350, (float)base2Left.field_1352, (float)base2Left.field_1351, (float)base2Left.field_1350, c2, c1);
        }
        poseStack.method_22909();
    }
}

