/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.util;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import it.hurts.shatterbyte.shatterlib.mixin.GuiGraphicsAccessor;
import java.awt.geom.Point2D;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.joml.Vector3f;

public class RenderUtils {
    public static class_241 toScreenCoords(Matrix3x2f matrix, double x, double y) {
        Matrix3x2f inverse = new Matrix3x2f((Matrix3x2fc)matrix);
        inverse.invert();
        return RenderUtils.toViewportCoords(inverse, x, y);
    }

    public static class_241 toViewportCoords(Matrix3x2f matrix, double x, double y) {
        Vector3f vec = new Vector3f((float)x, (float)y, 1.0f);
        vec = matrix.transform(vec);
        return new class_241(vec.x(), vec.y());
    }

    private boolean isPointInQuad(double x, double y, Point2D[] quad) {
        return this.pointInTriangle(x, y, quad[0], quad[1], quad[2]) || this.pointInTriangle(x, y, quad[0], quad[2], quad[3]);
    }

    public static void renderOutline(class_332 guiGraphics, int x, int y, int width, int height, int color) {
        guiGraphics.method_25294(x, y, x + width, y + 1, color);
        guiGraphics.method_25294(x, y + height - 1, x + width, y + height, color);
        guiGraphics.method_25294(x, y + 1, x + 1, y + height - 1, color);
        guiGraphics.method_25294(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    private boolean pointInTriangle(double px, double py, Point2D a, Point2D b, Point2D c) {
        double area = 0.5 * (-b.getY() * c.getX() + a.getY() * (-b.getX() + c.getX()) + a.getX() * (b.getY() - c.getY()) + b.getX() * c.getY());
        double sign = area < 0.0 ? -1.0 : 1.0;
        double s = (a.getY() * c.getX() - a.getX() * c.getY() + (c.getY() - a.getY()) * px + (a.getX() - c.getX()) * py) * sign;
        double t = (a.getX() * b.getY() - a.getY() * b.getX() + (a.getY() - b.getY()) * px + (b.getX() - a.getX()) * py) * sign;
        return s >= 0.0 && t >= 0.0 && s + t <= 2.0 * area * sign;
    }

    public static void renderTextureFromCenter(RenderPipeline pipeline, class_2960 texture, class_332 guiGraphics, float centerX, float centerY, float width, float height, float scale, int color, float zOffset) {
        RenderUtils.renderTextureFromCenter(pipeline, texture, guiGraphics, centerX, centerY, 0.0f, 0.0f, (int)width, (int)height, width, height, scale, color);
    }

    public static void renderTextureFromCenter(RenderPipeline pipeline, class_2960 texture, class_332 guiGraphics, float centerX, float centerY, float texOffX, float texOffY, int texWidth, int texHeight, float width, float height, float scale, int color) {
        float scaledWidth = width * scale;
        float scaledHeight = height * scale;
        float x = centerX - scaledWidth * 0.5f;
        float y = centerY - scaledHeight * 0.5f;
        float u = texOffX;
        float v = texOffY;
        int regionW = Math.round(width);
        int regionH = Math.round(height);
        guiGraphics.method_25291(pipeline, texture, (int)x, (int)y, u, v, regionW, regionH, texWidth, texHeight, color);
    }

    public static void renderTilingTexture(RenderPipeline pipeline, class_2960 texture, class_332 guiGraphics, float x, float y, float texOffX, float texOffY, float texWidth, float texHeight, float width, float height, int color, boolean tileHorizontally, boolean tileVertically) {
        float uStart = texOffX / texWidth;
        float vStart = texOffY / texHeight;
        float uRange = tileHorizontally ? width / texWidth : 1.0f;
        float vRange = tileVertically ? height / texHeight : 1.0f;
        float uEnd = uStart + uRange;
        float vEnd = vStart + vRange;
        Matrix3x2fStack matrix = guiGraphics.method_51448();
        matrix.pushMatrix();
        matrix.translate(x, y);
        GuiGraphicsAccessor accessor = (GuiGraphicsAccessor)guiGraphics;
        accessor.innerBlitAccessor(pipeline, texture, 0, (int)width, 0, (int)height, uStart, uEnd, vStart, vEnd, color);
        matrix.popMatrix();
    }
}

