/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.util;

import it.hurts.shatterbyte.shatterlib.util.AnimationUtils;
import java.util.Objects;

public final class ShatterColor {
    public static final ShatterColor RED = new ShatterColor(1.0f, 0.0f, 0.0f, 1.0f);
    public static final ShatterColor GREEN = new ShatterColor(0.0f, 1.0f, 0.0f, 1.0f);
    public static final ShatterColor BLUE = new ShatterColor(0.0f, 0.0f, 1.0f, 1.0f);
    public static final ShatterColor WHITE = new ShatterColor(1.0f, 1.0f, 1.0f, 1.0f);
    public static final ShatterColor BLACK = new ShatterColor(0.0f, 0.0f, 0.0f, 1.0f);
    public static final ShatterColor ZERO = new ShatterColor(0.0f, 0.0f, 0.0f, 0.0f);
    private final float r;
    private final float g;
    private final float b;
    private final float a;

    public ShatterColor(float red, float green, float blue, float alpha) {
        this.r = red;
        this.g = green;
        this.b = blue;
        this.a = alpha;
    }

    public static ShatterColor fromHSV(float hue, float saturation, float value, float alpha) {
        if ((hue %= 1.0f) < 0.0f) {
            hue += 1.0f;
        }
        saturation = Math.min(Math.max(saturation, 0.0f), 1.0f);
        value = Math.min(Math.max(value, 0.0f), 1.0f);
        float tempR = 0.0f;
        float tempG = 0.0f;
        float tempB = 0.0f;
        if (saturation == 0.0f) {
            tempG = tempB = value;
            tempR = tempB;
        } else {
            float i = (float)Math.floor(hue * 6.0f);
            float f = hue * 6.0f - i;
            float p = value * (1.0f - saturation);
            float q = value * (1.0f - saturation * f);
            float t = value * (1.0f - saturation * (1.0f - f));
            int sector = (int)i % 6;
            switch (sector) {
                case 0: {
                    tempR = value;
                    tempG = t;
                    tempB = p;
                    break;
                }
                case 1: {
                    tempR = q;
                    tempG = value;
                    tempB = p;
                    break;
                }
                case 2: {
                    tempR = p;
                    tempG = value;
                    tempB = t;
                    break;
                }
                case 3: {
                    tempR = p;
                    tempG = q;
                    tempB = value;
                    break;
                }
                case 4: {
                    tempR = t;
                    tempG = p;
                    tempB = value;
                    break;
                }
                case 5: {
                    tempR = value;
                    tempG = p;
                    tempB = q;
                }
            }
        }
        return new ShatterColor(tempR, tempG, tempB, alpha);
    }

    public float[] toHSV() {
        float min = Math.min(this.r, Math.min(this.g, this.b));
        float max = Math.max(this.r, Math.max(this.g, this.b));
        float delta = max - min;
        float v = max;
        if (max == 0.0f) {
            float s = 0.0f;
            float h = 0.0f;
            return new float[]{h, s, v};
        }
        float s = delta / max;
        float h = delta == 0.0f ? 0.0f : (this.r == max ? (this.g - this.b) / delta : (this.g == max ? 2.0f + (this.b - this.r) / delta : 4.0f + (this.r - this.g) / delta));
        h /= 6.0f;
        if (h < 0.0f) {
            h += 1.0f;
        }
        return new float[]{h, s, v};
    }

    public ShatterColor(int argb) {
        this.a = (float)(argb >> 24 & 0xFF) / 255.0f;
        this.r = (float)(argb >> 16 & 0xFF) / 255.0f;
        this.g = (float)(argb >> 8 & 0xFF) / 255.0f;
        this.b = (float)(argb & 0xFF) / 255.0f;
    }

    public int getARGB() {
        return ((int)(this.a * 255.0f) & 0xFF) << 24 | ((int)(this.r * 255.0f) & 0xFF) << 16 | ((int)(this.g * 255.0f) & 0xFF) << 8 | (int)(this.b * 255.0f) & 0xFF;
    }

    public ShatterColor lerp(ShatterColor other, double t) {
        return new ShatterColor(AnimationUtils.FLOAT.lerp(Float.valueOf(this.r), Float.valueOf(other.r), t).floatValue(), AnimationUtils.FLOAT.lerp(Float.valueOf(this.g), Float.valueOf(other.g), t).floatValue(), AnimationUtils.FLOAT.lerp(Float.valueOf(this.b), Float.valueOf(other.b), t).floatValue(), AnimationUtils.FLOAT.lerp(Float.valueOf(this.a), Float.valueOf(other.a), t).floatValue());
    }

    public static ShatterColor lerp(double t, ShatterColor ... colors) {
        if (colors == null || colors.length == 0) {
            throw new IllegalArgumentException("colors array can't be empty");
        }
        if (colors.length == 1) {
            return colors[0];
        }
        t = Math.min(Math.max(t, 0.0), 1.0);
        double scaledT = t * (double)(colors.length - 1);
        int index = (int)Math.floor(scaledT);
        int nextIndex = Math.min(index + 1, colors.length - 1);
        double localT = scaledT - (double)index;
        return colors[index].lerp(colors[nextIndex], localT);
    }

    public ShatterColor add(ShatterColor other) {
        return new ShatterColor(this.r + other.r, this.g + other.g, this.b + other.b, this.a + other.a);
    }

    public ShatterColor subtract(ShatterColor other) {
        return new ShatterColor(this.r - other.r, this.g - other.g, this.b - other.b, this.a - other.a);
    }

    public ShatterColor multiply(float rFactor, float gFactor, float bFactor, float aFactor) {
        return new ShatterColor(this.r * rFactor, this.g * gFactor, this.b * bFactor, this.a * aFactor);
    }

    public ShatterColor multiply(float factor) {
        return this.multiply(factor, factor, factor, factor);
    }

    public float r() {
        return this.r;
    }

    public float g() {
        return this.g;
    }

    public float b() {
        return this.b;
    }

    public float a() {
        return this.a;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ShatterColor that = (ShatterColor)obj;
        return Float.floatToIntBits(this.r) == Float.floatToIntBits(that.r) && Float.floatToIntBits(this.g) == Float.floatToIntBits(that.g) && Float.floatToIntBits(this.b) == Float.floatToIntBits(that.b) && Float.floatToIntBits(this.a) == Float.floatToIntBits(that.a);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    public String toString() {
        return "ShatterColor[r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "]";
    }
}

