/*
 * Decompiled with CFR 0.152.
 */
package smsk.smoothscroll.cfg;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import smsk.smoothscroll.cfg.CfgValueBuilder;
import smsk.smoothscroll.menu.CustomSlider;

public class CfgValue {
    final Object defaultValue;
    Object currentValue;
    String valueName;
    boolean isFake = false;
    CfgValue parent = null;
    float minVal;
    float maxVal;
    double step = 0.01;
    Object temporaryValue;
    class_339 myWidget;
    class_4185 myResetButton;
    class_2561 tooltiptxt;
    Map<Object, String> translationMap = new HashMap<Object, String>();
    String unformatted = "%s: %s";
    Function<CfgValue, Boolean> disableWhen;

    public CfgValue(String name, Object defaultVal) {
        this.valueName = name;
        this.defaultValue = defaultVal;
        this.temporaryValue = this.currentValue = defaultVal;
        List<CfgValue> list = this.getList();
        if (list != null) {
            for (CfgValue cfgValue : list) {
                cfgValue.parent = this;
            }
        }
    }

    public static CfgValueBuilder builder(String name, Object defaultVal) {
        return new CfgValueBuilder(name, defaultVal);
    }

    public CfgValue get(String name) {
        if (name == "..") {
            return this.parent != null ? this.parent : CfgValue.makeFake();
        }
        List<CfgValue> cfgValueList = this.getList();
        if (cfgValueList == null) {
            return CfgValue.makeFake();
        }
        for (CfgValue cfgValue : cfgValueList) {
            if (!cfgValue.valueName.equals(name)) continue;
            return cfgValue;
        }
        return CfgValue.makeFake();
    }

    public List<CfgValue> getList() {
        List list;
        if (this.getValue() instanceof List && !(list = (List)this.getValue()).isEmpty() && list.get(0) instanceof CfgValue) {
            List cfgValueList = (List)this.getValue();
            return cfgValueList;
        }
        return null;
    }

    public String getName() {
        return this.valueName;
    }

    public Object getValue() {
        return this.currentValue;
    }

    public boolean exists() {
        return !this.isFake;
    }

    public static CfgValue makeFake() {
        CfgValue ret = new CfgValue("", null);
        ret.isFake = true;
        return ret;
    }

    public void setValue(Object value) {
        this.temporaryValue = this.currentValue = value;
    }

    public void setTempValue(Object value) {
        this.temporaryValue = value;
    }

    public Object getTempValue() {
        return this.temporaryValue;
    }

    public void saveTempValue() {
        this.currentValue = this.temporaryValue;
    }

    public void resetTempValue() {
        this.temporaryValue = this.currentValue;
    }

    public void defaultToTemp() {
        this.temporaryValue = this.defaultValue;
        if (this.myWidget != null) {
            class_339 class_3392 = this.myWidget;
            if (class_3392 instanceof CustomSlider) {
                CustomSlider cs = (CustomSlider)class_3392;
                cs.refreshValue();
            }
            if ((class_3392 = this.myWidget) instanceof class_4185) {
                class_4185 bw = (class_4185)class_3392;
                bw.method_25355((class_2561)class_2561.method_43470((String)this.makeButtonText()));
            }
        }
    }

    public void recursiveSaveTempValue() {
        List<CfgValue> a = this.getList();
        if (a != null) {
            for (CfgValue cfgValue2 : a) {
                cfgValue2.recursiveSaveTempValue();
            }
            return;
        }
        this.saveTempValue();
    }

    public class_339[] generateWidget() {
        this.myResetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\uddd1"), button -> this.defaultToTemp()).method_46431();
        if (this.getValue() instanceof Number) {
            this.myWidget = new CustomSlider(this);
            this.assignWidget(this.myWidget);
            if (this.tooltiptxt != null) {
                this.myWidget.method_47400(class_7919.method_47407((class_2561)this.tooltiptxt));
            }
            return new class_339[]{this.myWidget, this.myResetButton};
        }
        if (this.getValue() instanceof Boolean) {
            this.myWidget = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.makeButtonText()), button -> {
                this.setTempValue((Boolean)this.getTempValue() == false);
                button.method_25355((class_2561)class_2561.method_43470((String)this.makeButtonText()));
            }).method_46431();
            if (this.tooltiptxt != null) {
                this.myWidget.method_47400(class_7919.method_47407((class_2561)this.tooltiptxt));
            }
            this.assignWidget(this.myWidget);
            return new class_339[]{this.myWidget, this.myResetButton};
        }
        this.myWidget = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.makeButtonText()), button -> {}).method_46431();
        return new class_339[]{this.myWidget, this.myResetButton};
    }

    private String makeButtonText() {
        return this.getName() + ": " + String.valueOf(this.getTempValue());
    }

    public static CfgValue parseJson(String name, JsonElement jsonData) {
        CfgValue a = new CfgValue(name, null);
        if (jsonData == null) {
            return a;
        }
        if (jsonData.isJsonObject()) {
            Map objMap = jsonData.getAsJsonObject().asMap();
            ArrayList<CfgValue> b = new ArrayList<CfgValue>();
            for (String elementName : objMap.keySet()) {
                b.add(CfgValue.parseJson(elementName, (JsonElement)objMap.get(elementName)));
            }
            a.setValue(b);
        } else if (jsonData.isJsonPrimitive()) {
            JsonPrimitive primitive = jsonData.getAsJsonPrimitive();
            if (primitive.isString()) {
                a.setValue(primitive.getAsString());
            } else if (primitive.isBoolean()) {
                a.setValue(primitive.getAsBoolean());
            } else if (primitive.isNumber()) {
                Number number = primitive.getAsNumber();
                a.setValue(Float.valueOf(number.floatValue()));
            }
        }
        return a;
    }

    public void matchValues(CfgValue source) {
        CfgValue.matchValues(source, this);
    }

    public static void matchValues(CfgValue source, CfgValue destination) {
        if (source.getValue() == null) {
            return;
        }
        if (destination != null && !destination.getValue().getClass().equals(source.getValue().getClass())) {
            return;
        }
        List<CfgValue> a = source.getList();
        List<CfgValue> b = destination.getList();
        if (a == null && b == null) {
            destination.setValue(source.getValue());
        }
        if (a == null || b == null) {
            return;
        }
        for (CfgValue destval : b) {
            for (CfgValue srcval : a) {
                if (!destval.valueName.equals(srcval.valueName)) continue;
                CfgValue.matchValues(srcval, destval);
            }
        }
    }

    public static JsonElement exportJson(CfgValue toExport) {
        List<CfgValue> a = toExport.getList();
        if (a != null) {
            JsonObject b = new JsonObject();
            for (CfgValue cfgValue : a) {
                b.add(cfgValue.valueName, CfgValue.exportJson(cfgValue));
            }
            return b;
        }
        return new Gson().toJsonTree(toExport.getValue());
    }

    public String toString() {
        return "(" + this.valueName + ":" + String.valueOf(this.currentValue) + ")";
    }

    public double getStep() {
        return this.step;
    }

    public void assignWidget(class_339 cw) {
        this.myWidget = cw;
    }

    public double getMax() {
        return this.maxVal;
    }

    public double getMin() {
        return this.minVal;
    }

    public String getUnformatted() {
        return this.unformatted;
    }

    public String tryTranslate(Object value) {
        return this.translationMap.getOrDefault(value, String.valueOf(value));
    }

    public void refreshDisableRecursive() {
        List<CfgValue> list = this.getList();
        if (list == null) {
            if (this.disableWhen == null) {
                return;
            }
            Boolean shouldBeDisabled = this.disableWhen.apply(this);
            this.myWidget.field_22763 = shouldBeDisabled == false;
            this.myResetButton.field_22763 = shouldBeDisabled == false;
            return;
        }
        for (CfgValue cfgValue : list) {
            cfgValue.refreshDisableRecursive();
        }
    }

    public long enHelfStep(double val) {
        return Math.round(val / this.getStep());
    }

    public double enStep(double val) {
        return (double)this.enHelfStep(val) * this.getStep();
    }

    public double enMinMax(double val) {
        return val * (this.getMax() - this.getMin()) + this.getMin();
    }

    public double deMinMax(double val) {
        return (val - this.getMin()) / this.getMax();
    }
}

