/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.util.DisplayEntryRenderHelper;
import fuzs.pickupnotifier.config.ClientConfig;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_9848;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class DisplayEntry<T> {
    public static final int ELEMENT_HEIGHT = 18;
    private static final int TEXT_ITEM_MARGIN = 4;
    protected final T item;
    private final int displayAmount;
    private final class_2561 component;
    private int remainingTicks;

    public DisplayEntry(T item, int displayAmount, class_1814 rarity) {
        this.remainingTicks = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime;
        this.item = item;
        this.displayAmount = displayAmount;
        this.component = class_2561.method_43473().method_10852(this.createTextComponent()).method_10862(this.getComponentStyle(rarity));
    }

    public Object getKey() {
        return this;
    }

    protected abstract class_2561 getEntryName(T var1);

    public int getDisplayAmount() {
        return this.displayAmount;
    }

    public boolean mayDiscard() {
        return this.remainingTicks <= 0;
    }

    @MustBeInvokedByOverriders
    public void tick() {
        if (this.remainingTicks > 0) {
            --this.remainingTicks;
        }
    }

    protected final class_2561 createTextComponent() {
        boolean reverse = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.isRight();
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        this.appendTextComponents(components, reverse);
        if (reverse) {
            Collections.reverse(components);
        }
        return (class_2561)components.stream().reduce((component1, component2) -> class_2561.method_43473().method_10852(component1).method_10852(class_5244.field_41874).method_10852(component2)).orElse(class_2561.method_43473());
    }

    @MustBeInvokedByOverriders
    protected void appendTextComponents(List<class_2561> components, boolean reverse) {
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayItemName) {
            components.add(this.getEntryName(this.item));
        }
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.isText() && (this.displayAmount > 1 || this.displayAmount == 1 && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount)) {
            components.add((class_2561)class_2561.method_43470((String)(reverse ? this.displayAmount + "x" : "x" + this.displayAmount)));
        }
    }

    private class_2583 getComponentStyle(class_1814 rarity) {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.ignoreRarity && rarity != class_1814.field_8906) {
            return ItemHelper.getRarityStyle((class_1814)rarity);
        }
        return class_2583.field_24360.method_10977(((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.textColor);
    }

    public static double getRelativeRemainingTicks(Collection<DisplayEntry<?>> values, float partialTick) {
        return values.stream().mapToDouble(displayEntry -> 1.0 - (double)displayEntry.getRelativeRemainingTicks(partialTick)).average().orElse(0.0) * (double)values.size();
    }

    public final float getRelativeRemainingTicks(float partialTick) {
        float moveTime = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.getMoveTime();
        return class_3532.method_15363((float)(((float)this.remainingTicks - partialTick) / moveTime), (float)0.0f, (float)1.0f);
    }

    public abstract DisplayEntry<?> mergeWith(DisplayEntry<?> var1);

    public int getEntryWidth(class_327 font) {
        int textWidth = font.method_27525((class_5348)this.component);
        return ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite ? textWidth + (textWidth == 0 ? 0 : 4) + 16 : textWidth;
    }

    public void render(class_332 guiGraphics, class_327 font, int posX, int posY, float alpha) {
        float scale = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.getDisplayScale();
        boolean mirrorPosition = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.isRight();
        boolean withSprite = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite;
        int textStartX = mirrorPosition || !withSprite ? posX : posX + 16 + 4;
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().scale(scale, scale);
        this.renderBg(guiGraphics, font, posX, posY, alpha);
        guiGraphics.method_51439(font, this.component, textStartX, posY + 4, class_9848.method_61317((float)alpha), true);
        if (withSprite) {
            int textWidth = font.method_27525((class_5348)this.component);
            this.renderSprite(guiGraphics, font, mirrorPosition ? posX + textWidth + (textWidth == 0 ? 0 : 4) : posX, posY, alpha);
        }
        guiGraphics.method_51448().popMatrix();
    }

    private void renderBg(class_332 guiGraphics, class_327 font, int posX, int posY, float alpha) {
        switch (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.entryBackground) {
            case CHAT: {
                int backgroundOpacity = class_9848.method_61330((int)class_9848.method_61326((float)class_3532.method_15363((float)(((Double)class_310.method_1551().field_1690.method_42550().method_41753()).floatValue() * alpha), (float)0.0f, (float)1.0f)), (int)0);
                int endY = posY + 16;
                if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.isSprite()) {
                    ++endY;
                }
                guiGraphics.method_25294(posX - 3, posY, posX + this.getEntryWidth(font) + 5, endY, backgroundOpacity);
                break;
            }
            case TOOLTIP: {
                DisplayEntryRenderHelper.renderTooltipBackground(guiGraphics, posX, posY + 3, this.getEntryWidth(font), 9, class_9848.method_61317((float)alpha));
            }
        }
    }

    protected abstract void renderSprite(class_332 var1, class_327 var2, int var3, int var4, float var5);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

