/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.config.ACJsonHandler;
import io.github.thecsdev.tcdcommons.api.config.annotation.NonSerialized;
import io.github.thecsdev.tcdcommons.api.config.annotation.SerializedAs;
import io.github.thecsdev.tcdcommons.api.util.TUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@Virtual
public class AutoConfig
implements ACJsonHandler<JsonObject> {
    @NonSerialized
    protected static final transient String FILE_EXTENSION = "json";
    @NonSerialized
    protected static final transient Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @NonSerialized
    public final transient String fileName;
    @NonSerialized
    public final transient Path filePath;

    public AutoConfig(String name) throws InvalidPathException {
        this.fileName = name.strip().replaceAll("[\\\\/:*?\"<>|]", "") + ".json";
        this.filePath = Path.of(System.getProperty("user.dir"), "config", this.fileName);
    }

    public final List<Field> getPropertyFields() {
        return Arrays.asList(this.getClass().getFields()).stream().filter(field -> {
            int fieldMods = field.getModifiers();
            return !Modifier.isStatic(fieldMods) && !Modifier.isFinal(fieldMods) && !Modifier.isTransient(fieldMods) && field.canAccess(this) && (field.getType().isPrimitive() || ACJsonHandler.class.isAssignableFrom(field.getType())) && field.getAnnotation(NonSerialized.class) == null;
        }).toList();
    }

    @Nullable
    protected final JsonElement serializeProperty(Field property) {
        try {
            Object val = property.get(this);
            if (ACJsonHandler.class.isAssignableFrom(property.getType())) {
                return ((ACJsonHandler)val).saveToJson();
            }
            return GSON.toJsonTree(val);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected final boolean deserializeProperty(Field property, JsonElement jEl) {
        try {
            if (ACJsonHandler.class.isAssignableFrom(property.getType())) {
                Object objVal = property.get(jEl);
                if (objVal == null) {
                    throw new NullPointerException();
                }
                ACJsonHandler val = (ACJsonHandler)objVal;
                val.loadFromJsonElement(jEl);
            } else {
                property.set(this, GSON.fromJson(jEl, property.getType()));
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final String getPropertyName(Field property) {
        SerializedAs sa = property.getAnnotation(SerializedAs.class);
        if (sa != null) {
            return sa.value();
        }
        return property.getName();
    }

    @Override
    @Virtual
    public JsonObject saveToJson() {
        JsonObject result = new JsonObject();
        for (Field property : this.getPropertyFields()) {
            JsonElement serializedElement = this.serializeProperty(property);
            if (serializedElement == null) continue;
            result.add(this.getPropertyName(property), serializedElement);
        }
        return result;
    }

    @Override
    @Virtual
    public boolean loadFromJson(JsonObject json) {
        for (Field property : this.getPropertyFields()) {
            String propertyName = this.getPropertyName(property);
            if (!json.has(propertyName)) continue;
            this.deserializeProperty(property, json.get(propertyName));
        }
        return true;
    }

    public final void saveToFile(boolean log) throws IOException, SecurityException {
        JsonObject json = this.saveToJson();
        String jsonStr = GSON.toJson((JsonElement)json);
        this.filePath.toFile().delete();
        Files.writeString(this.filePath, (CharSequence)jsonStr, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        if (log) {
            TCDCommons.LOGGER.info("Saved '" + this.getClass().getSimpleName() + "' config to '" + this.fileName + "'.");
        }
    }

    public final void saveToFileOrCrash(boolean log) {
        try {
            this.saveToFile(log);
        }
        catch (Exception exc) {
            TUtils.throwCrash("Failed to save config file \"" + this.fileName + "\"", exc);
        }
    }

    public final boolean trySaveToFile(boolean log) {
        try {
            this.saveToFile(log);
        }
        catch (IOException exc) {
            return false;
        }
        return true;
    }

    public final void loadFromFile(boolean log) throws IOException {
        if (!this.filePath.toFile().exists()) {
            return;
        }
        String jsonStr = Files.readString(this.filePath);
        JsonObject json = null;
        try {
            json = JsonParser.parseString((String)jsonStr).getAsJsonObject();
        }
        catch (Exception exc) {
            if (exc instanceof JsonParseException) {
                if (log) {
                    TCDCommons.LOGGER.error("Unable to load '" + this.fileName + "' config. Could not parse the JSON.");
                }
            }
            if (exc instanceof JsonSyntaxException) {
                if (log) {
                    TCDCommons.LOGGER.error("Unable to load '" + this.fileName + "' config. Invalid JSON syntax.");
                }
            }
            if (exc instanceof IllegalStateException) {
                if (log) {
                    TCDCommons.LOGGER.error("Unable to load '" + this.fileName + "' config. Invalid JSON element type.");
                }
            }
            throw exc;
        }
        if (json != null) {
            this.loadFromJson(json);
            if (log) {
                TCDCommons.LOGGER.info("Loaded '" + this.getClass().getSimpleName() + "' config from '" + this.fileName + "'.");
            }
        }
    }

    public final void loadFromFileOrCrash(boolean log) {
        try {
            this.loadFromFile(log);
        }
        catch (IOException exc) {
            TUtils.throwCrash("Failed to load config file \"" + this.fileName + "\".", exc);
        }
    }

    public final boolean tryLoadFromFile(boolean log) {
        try {
            this.loadFromFile(log);
        }
        catch (IOException exc) {
            return false;
        }
        return true;
    }
}

