/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test.gui.widgets;

import fi.dy.masa.malilib.gui.widgets.WidgetListEntrySortable;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.test.gui.GuiTestList;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class WidgetTestListEntry
extends WidgetListEntrySortable<GuiTestList.Entry> {
    private final GuiTestList parent;
    private final GuiTestList.Entry entry;
    private final boolean isOdd;
    private static int maxNameLengthExpected;
    private static int maxNameLengthFound;
    private static int maxCountLength;

    public WidgetTestListEntry(int x, int y, int width, int height, boolean isOdd, @Nullable GuiTestList.Entry entry, GuiTestList parent, int listIndex) {
        super(x, y, width, height, entry, listIndex);
        this.entry = entry;
        this.isOdd = isOdd;
        this.parent = parent;
    }

    public GuiTestList getParent() {
        return this.parent;
    }

    public boolean isOdd() {
        return this.isOdd;
    }

    @Override
    @Nullable
    public GuiTestList.Entry getEntry() {
        return this.entry;
    }

    @Override
    protected int getColumnPosX(int column) {
        int x1 = this.x + 4;
        int x2 = x1 + maxNameLengthExpected + 56;
        int x3 = x2 + maxNameLengthFound + 56;
        return switch (column) {
            case 1 -> x2;
            case 2 -> x3;
            case 3 -> x3 + maxCountLength + 20;
            default -> x1;
        };
    }

    @Override
    protected int getCurrentSortColumn() {
        return 0;
    }

    @Override
    protected boolean getSortInReverse() {
        return false;
    }

    public static void setMaxEntryLength(List<GuiTestList.Entry> entryList) {
        maxNameLengthExpected = 9;
        maxNameLengthFound = 9;
        maxCountLength = 3 * maxNameLengthExpected;
        for (GuiTestList.Entry entry : entryList) {
            class_2248 block = entry.getBlock();
            String name = block.method_9518().getString();
            maxNameLengthExpected = Math.max(maxNameLengthExpected, StringUtils.getStringWidth(name));
            maxNameLengthFound = Math.max(maxNameLengthFound, StringUtils.getStringWidth(name));
        }
        maxCountLength = Math.max(maxCountLength, 3 * maxNameLengthFound);
    }

    @Override
    public void render(class_332 drawContext, int mouseX, int mouseY, boolean selected) {
        int color = -1607454672;
        if (selected) {
            color = -1603243920;
        } else if (this.isMouseOver(mouseX, mouseY)) {
            color = -1605349296;
        } else if (this.isOdd) {
            color = -1609560048;
        }
        RenderUtils.drawRect(drawContext, this.x, this.y, this.width, this.height, color);
        if (selected) {
            RenderUtils.drawOutline(drawContext, this.x, this.y, this.width, this.height, -2039584);
        }
        int x1 = this.getColumnPosX(0);
        int x2 = this.getColumnPosX(1);
        int x3 = this.getColumnPosX(2);
        int iconSize = this.parent.iconSize;
        int y = this.y + iconSize;
        color = -1;
        if (this.entry != null) {
            this.drawString(drawContext, x1 + iconSize + 4, y - iconSize / 2, color, this.entry.name());
            y = this.y + 3;
            RenderUtils.drawRect(drawContext, x1, y, iconSize, iconSize, 0x20FFFFFF);
            RenderUtils.renderModelInGui(drawContext, x1, y, iconSize, this.entry.state(), 0.625f);
        }
        super.render(drawContext, mouseX, mouseY, selected);
    }
}

