/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render;

import fabric.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import fabric.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render.AsyncRendererThread;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import fabric.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_3532;
import net.minecraft.class_6558;
import org.jetbrains.annotations.NotNull;

public class AsyncRenderBehavior {
    public static final int THREADS = class_3532.method_15340((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleRenderer";
    private static boolean particlePhase;
    private static final List<ForkJoinTask<?>> futures;
    private static final ExceptionTracker<Object> EXCEPTION_TRACKER;

    public static boolean isTolerable(@NotNull Throwable e) {
        if (!(e instanceof Exception)) {
            return false;
        }
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        return rootCause instanceof class_6558 || rootCause instanceof NullPointerException || rootCause instanceof IndexOutOfBoundsException || rootCause instanceof ArrayIndexOutOfBoundsException || rootCause instanceof ConcurrentModificationException && ConfigHelper.suppressCME();
    }

    public static boolean isParticlePhase() {
        return particlePhase;
    }

    public static void waitRenderingFuture() {
        class_128 crashReport = null;
        class_129 category = null;
        for (ForkJoinTask<?> task : futures) {
            try {
                task.get();
            }
            catch (Exception e) {
                if (category == null) {
                    crashReport = class_128.method_560((Throwable)new RuntimeException(), (String)"Exception during rendering");
                    category = crashReport.method_562("Supressed exceptions");
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                category.method_578("Supressed exception", (Object)sw.toString());
            }
        }
        futures.clear();
        if (category != null) {
            throw new class_148(crashReport);
        }
    }

    public static void addRenderingFuture(ForkJoinTask<?> future) {
        futures.add(future);
    }

    static {
        futures = new ArrayList();
        AtomicInteger workerCount = new AtomicInteger(1);
        EXECUTOR = new ForkJoinPool(THREADS, forkJoinPool -> {
            AsyncRendererThread forkJoinWorkerThread = new AsyncRendererThread(forkJoinPool);
            forkJoinWorkerThread.setName("AsyncParticleRenderer-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, class_156::method_18347, true);
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getTickFailurePerSecondThreshold);
    }
}

