/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render.AsyncRendererThread;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import org.jetbrains.annotations.NotNull;

public class AsyncRenderBehavior {
    public static final int THREADS = Mth.clamp((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleRenderer";
    private static boolean particlePhase;
    private static final List<ForkJoinTask<?>> futures;
    private static final ExceptionTracker<Object> EXCEPTION_TRACKER;

    public static boolean isTolerable(@NotNull Throwable e) {
        if (!(e instanceof Exception)) {
            return false;
        }
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        return rootCause instanceof MissingPaletteEntryException || rootCause instanceof NullPointerException || rootCause instanceof IndexOutOfBoundsException || rootCause instanceof ArrayIndexOutOfBoundsException || rootCause instanceof ConcurrentModificationException && ConfigHelper.suppressCME();
    }

    public static boolean isParticlePhase() {
        return particlePhase;
    }

    public static void waitRenderingFuture() {
        CrashReport crashReport = null;
        CrashReportCategory category = null;
        for (ForkJoinTask<?> task : futures) {
            try {
                task.get();
            }
            catch (Exception e) {
                if (category == null) {
                    crashReport = CrashReport.forThrowable((Throwable)new RuntimeException(), (String)"Exception during rendering");
                    category = crashReport.addCategory("Supressed exceptions");
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                category.setDetail("Supressed exception", (Object)sw.toString());
            }
        }
        futures.clear();
        if (category != null) {
            throw new ReportedException(crashReport);
        }
    }

    public static void addRenderingFuture(ForkJoinTask<?> future) {
        futures.add(future);
    }

    static {
        futures = new ArrayList();
        AtomicInteger workerCount = new AtomicInteger(1);
        EXECUTOR = new ForkJoinPool(THREADS, forkJoinPool -> {
            AsyncRendererThread forkJoinWorkerThread = new AsyncRendererThread(forkJoinPool);
            forkJoinWorkerThread.setName("AsyncParticleRenderer-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, Util::onThreadException, true);
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getTickFailurePerSecondThreshold);
    }
}

