/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_tick;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleGroupAddition;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_render.AsyncRendererThread;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleGroup;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.util.Mth;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import org.jetbrains.annotations.NotNull;

public class AsyncTickBehavior {
    public static final int THREADS = Mth.clamp((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleTicker";
    private static Runnable tickFuture;
    private static Runnable cleanupFuture;
    private static final List<Runnable> tickTasks;
    private static final ExceptionTracker<Object> EXCEPTION_TRACKER;

    public static <T extends Particle> void onEvict(T particle) {
        particle.getParticleLimit().ifPresent(limit -> Minecraft.getInstance().particleEngine.updateCount(limit, -1));
        if (particle.isAlive()) {
            particle.remove();
        }
    }

    public static void doEmittersRemoveIf(Queue<? extends TrackingEmitter> queue) {
        if (ConfigHelper.isParallelQueueRemoval()) {
            ((IterationSafeEvictingQueue)queue).parallelRemoveIf(particle -> !particle.isAlive(), ConfigHelper.isParallelQueueEviction(), THREADS, EXECUTOR);
        } else {
            queue.removeIf(particle -> AsyncTickBehavior.shouldRemove((Particle)particle, ConfigHelper.isRemoveIfMissedTick()));
        }
    }

    public static boolean shouldRemove(Particle particle, boolean removeIfMissedTick) {
        if (!particle.isAlive()) {
            return true;
        }
        ParticleAddon particleAddon = (ParticleAddon)particle;
        if (particleAddon.asyncparticles$isTickSync()) {
            return false;
        }
        if (particleAddon.asyncparticles$isTicked()) {
            particleAddon.asyncparticles$resetTicked();
            return false;
        }
        return removeIfMissedTick;
    }

    public static boolean isCancelled() {
        return false;
    }

    public static boolean isTolerable(@NotNull Throwable e) {
        if (!(e instanceof Exception)) {
            return false;
        }
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        return rootCause instanceof MissingPaletteEntryException || rootCause instanceof NullPointerException || rootCause instanceof IndexOutOfBoundsException || rootCause instanceof ArrayIndexOutOfBoundsException || rootCause instanceof ConcurrentModificationException && ConfigHelper.suppressCME();
    }

    public static ReportedException onTickParticleException(Particle particle, Throwable t) {
        if (ThreadUtil.isOnMainThread()) {
            return AsyncTickBehavior.constructCrashReport(particle, t);
        }
        boolean tolerable = AsyncTickBehavior.isTolerable(t);
        Class<? extends Particle> particleClass = ((ParticleAddon)particle).asyncparticles$getRealClass();
        if (tolerable && !EXCEPTION_TRACKER.addException(particleClass, t)) {
            return null;
        }
        throw AsyncTickBehavior.constructCrashReport(particle, t);
    }

    public static ReportedException constructCrashReport(Particle particle, Throwable t) {
        while (t instanceof CompletionException || t instanceof ExecutionException) {
            t = t.getCause();
        }
        if (t instanceof ReportedException) {
            ReportedException re = (ReportedException)t;
            return re;
        }
        CrashReport crashReport = CrashReport.forThrowable((Throwable)t, (String)"Ticking Particle");
        CrashReportCategory crashReportCategory = crashReport.addCategory("Particle being ticked");
        crashReportCategory.setDetail("Particle", () -> ((Particle)particle).toString());
        crashReportCategory.setDetail("Particle Type", () -> ((ParticleRenderType)particle.getGroup()).toString());
        return new ReportedException(crashReport);
    }

    public static void waitTickFuture() {
        if (tickFuture != null) {
            tickFuture.run();
            tickFuture = null;
        }
    }

    public static void waitCleanupFuture() {
        if (cleanupFuture != null) {
            cleanupFuture.run();
            cleanupFuture = null;
        }
    }

    public static void preTick(boolean isTheFirstTick) {
        boolean levelRunning;
        if (isTheFirstTick) {
            AsyncTickBehavior.waitTickFuture();
        }
        Minecraft mc = Minecraft.getInstance();
        boolean bl = levelRunning = mc.level != null && mc.player != null && !mc.isPaused();
        if (levelRunning) {
            if (cleanupFuture != null) {
                throw new IllegalStateException("cleanupFuture is not null!");
            }
            Collection groups = mc.particleEngine.particles.values();
            ForkJoinTask[] tasks = new ForkJoinTask[groups.size()];
            int idx = 0;
            for (ParticleGroup group : groups) {
                if (groups.isEmpty()) continue;
                int n = idx++;
                tasks[n] = EXECUTOR.submit(((ParticleGroupAddition)group)::asyncparticles$cleanUp);
            }
            cleanupFuture = () -> {
                for (ForkJoinTask task : tasks) {
                    if (task == null) break;
                    try {
                        task.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }

    public static void postTick(boolean isTheLastTick) {
        boolean levelRunning;
        AsyncTickBehavior.waitCleanupFuture();
        Minecraft mc = Minecraft.getInstance();
        boolean bl = levelRunning = mc.level != null && mc.player != null && !mc.isPaused();
        if (levelRunning) {
            mc.particleEngine.tick();
            if (!isTheLastTick) {
                tickTasks.forEach(Runnable::run);
            } else {
                ForkJoinTask[] tasks = (ForkJoinTask[])tickTasks.stream().map(EXECUTOR::submit).toArray(ForkJoinTask[]::new);
                tickFuture = () -> {
                    for (ForkJoinTask task : tasks) {
                        if (task == null) break;
                        try {
                            task.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            tickTasks.clear();
        }
    }

    public static void dispatch(Runnable tickParticles) {
        tickTasks.add(tickParticles);
    }

    static {
        tickTasks = new ArrayList<Runnable>();
        AtomicInteger workerCount = new AtomicInteger(1);
        EXECUTOR = new ForkJoinPool(THREADS, forkJoinPool -> {
            AsyncRendererThread forkJoinWorkerThread = new AsyncRendererThread(forkJoinPool);
            forkJoinWorkerThread.setName("AsyncParticleTicker-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, Util::onThreadException, true);
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getTickFailurePerSecondThreshold);
    }
}

