/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.conditional;

import java.util.Iterator;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Stream;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import net.minecraft.client.particle.ElderGuardianParticleGroup;
import net.minecraft.client.particle.ItemPickupParticleGroup;
import net.minecraft.client.particle.Particle;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ItemPickupParticleGroup.class, ElderGuardianParticleGroup.class})
public class MixinAsyncTick_TestAliveBeforeRender {
    @Redirect(method={"*"}, require=0, at=@At(value="INVOKE", target="Ljava/util/Queue;stream()Ljava/util/stream/Stream;"))
    @Dynamic
    @Group(name="checkAliveBeforeRender", min=1)
    private static <T extends Particle> Stream<T> redirectStream(Queue<T> queue) {
        if (queue instanceof IterationSafeEvictingQueue) {
            return queue.stream().filter(Particle::isAlive);
        }
        return queue.stream();
    }

    @Redirect(method={"*"}, require=0, at=@At(value="INVOKE", target="Ljava/util/Queue;forEach(Ljava/util/function/Consumer;)V"))
    @Dynamic
    @Group(name="checkAliveBeforeRender", min=1)
    private static <T extends Particle> void redirectForEach(Queue<T> queue, Consumer<T> consumer) {
        if (queue instanceof IterationSafeEvictingQueue) {
            for (Particle t : queue) {
                if (!t.isAlive()) continue;
                consumer.accept(t);
            }
        } else {
            queue.forEach(consumer);
        }
    }

    @Redirect(method={"*"}, require=0, at=@At(value="INVOKE", target="Ljava/util/Queue;iterator()Ljava/util/Iterator;"))
    @Dynamic
    @Group(name="checkAliveBeforeRender", min=1)
    private static <T extends Particle> Iterator<T> redirectIterator(Queue<T> queue) {
        if (queue instanceof IterationSafeEvictingQueue) {
            IterationSafeEvictingQueue iseq = (IterationSafeEvictingQueue)queue;
            return iseq.conditionalIterator(Particle::isAlive);
        }
        return queue.iterator();
    }
}

