/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.core.particle.async_tick;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_tick.AsyncTickBehavior;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_tick.AsyncTickParticleGroupBehavior;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.core.particle.async_tick.AsyncTickableParticleGroup;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleGroup;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.util.profiling.Profiler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ParticleEngine.class})
public abstract class MixinParticleEngine {
    @Shadow
    @Final
    private Queue<TrackingEmitter> trackingEmitters;
    @Shadow
    @Final
    private Queue<Particle> particlesToAdd;
    @Shadow
    @Final
    public Map<ParticleRenderType, ParticleGroup<?>> particles;

    @Shadow
    protected abstract ParticleGroup<?> createParticleGroup(ParticleRenderType var1);

    @Overwrite
    public void tick() {
        this.particles.forEach((particleRenderType, particleGroup) -> {
            Profiler.get().push(particleRenderType.name());
            if (particleGroup instanceof AsyncTickableParticleGroup && AsyncTickParticleGroupBehavior.canTickAsync(particleGroup)) {
                AsyncTickBehavior.dispatch(() -> ((ParticleGroup)particleGroup).tickParticles());
            } else {
                particleGroup.tickParticles();
            }
            Profiler.get().pop();
        });
        if (!this.trackingEmitters.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (TrackingEmitter trackingEmitter : this.trackingEmitters) {
                trackingEmitter.tick();
                if (trackingEmitter.isAlive()) continue;
                list.add(trackingEmitter);
            }
            this.trackingEmitters.removeAll(list);
        }
        if (!this.particlesToAdd.isEmpty()) {
            Particle particle;
            while ((particle = this.particlesToAdd.poll()) != null) {
                this.particles.computeIfAbsent(particle.getGroup(), this::createParticleGroup).add(particle);
            }
        }
    }
}

