/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.off_thread_access;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeArrayList;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.storage.WritableLevelData;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class}, priority=1500)
public abstract class MixinClientLevel
extends Level {
    @Mutable
    @Shadow
    @Final
    List<AbstractClientPlayer> players;

    protected MixinClientLevel(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, RegistryAccess registryAccess, Holder<DimensionType> holder, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, bl, bl2, l, i);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.players = new IterationSafeArrayList();
        if (this.random.getClass() != SingleThreadedRandomSource.class) {
            this.random = new SingleThreadedRandomSource(RandomSupport.generateUniqueSeed());
        }
    }

    public Player getPlayerByUUID(@NotNull UUID uuid) {
        for (Player player : this.players) {
            if (!Objects.equals(player.getUUID(), uuid)) continue;
            return player;
        }
        return null;
    }
}

