/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.common.counter;

import carpettisaddition.commands.common.counter.DyeCounterKey;
import carpettisaddition.translations.TranslationContext;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.CounterUtils;
import carpettisaddition.utils.GameUtils;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_5250;

public abstract class DyeCounter<Key extends DyeCounterKey>
extends TranslationContext {
    private final Object2LongMap<Key> counter = new Object2LongLinkedOpenHashMap();
    private final class_1767 color;
    private final class_5250 colorText;
    private final String commandPrefix;
    private final Translator baseTr = new Translator("command.dye_counter.counter");
    private long startTick;
    private long startMillis;
    private boolean running = false;

    public DyeCounter(class_1767 color, Translator translator, String commandPrefix) {
        super(translator);
        this.color = color;
        this.commandPrefix = commandPrefix;
        this.counter.defaultReturnValue(0L);
        this.colorText = Messenger.fancy(Messenger.colored(Messenger.color(color), color), Messenger.s(color.method_7792()), Messenger.ClickEvents.suggestCommand(this.getSelfCommandBase()));
    }

    protected abstract Comparator<? super Object2LongMap.Entry<Key>> getReportOrderComparator();

    protected abstract class_5250 getSymbolText();

    public class_5250 getColorText() {
        return this.colorText;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void addForKey(Key key, long count) {
        if (!this.isRunning()) {
            this.start();
        }
        long newCount = this.counter.getLong(key) + count;
        this.counter.put(key, newCount);
    }

    private void start() {
        this.startTick = GameUtils.getGameTime();
        this.startMillis = System.currentTimeMillis();
        this.counter.clear();
        this.running = true;
    }

    public void reset() {
        this.running = false;
    }

    private String getSelfCommandBase() {
        return String.format("/%s %s", this.commandPrefix, this.color.method_7792().toLowerCase());
    }

    private long getTotal() {
        return this.counter.values().longStream().sum();
    }

    public class_5250 reportBrief(boolean realTime) {
        class_5250 content;
        if (this.isRunning()) {
            long ticks = CounterUtils.getTimeElapsed(this.startTick, this.startMillis, realTime);
            long total = this.getTotal();
            content = Messenger.s(String.format("%d, %.1f/h, %.1f min", total, (double)total / CounterUtils.tickToHour(ticks), CounterUtils.tickToMinute(ticks)));
        } else {
            content = Messenger.s((Object)"N/A", "g");
        }
        return Messenger.c(this.colorText, "g : ", content, "g  (", this.getSymbolText(), "g )");
    }

    public List<class_5250> report(boolean realTime) {
        class_5250 counterNameText = Messenger.hover(this.tr("counter_name", new Object[0]), Messenger.s(this.commandPrefix));
        if (!this.isRunning()) {
            return Collections.singletonList(this.baseTr.tr("not_started", this.colorText, counterNameText));
        }
        long ticks = CounterUtils.getTimeElapsed(this.startTick, this.startMillis, realTime);
        long total = this.getTotal();
        class_5250 realtimeSuffix = realTime ? Messenger.c("g (", Messenger.formatting(this.baseTr.tr("realtime", new Object[0]), "g"), "g )") : Messenger.s("");
        ArrayList lines = Lists.newArrayList();
        lines.add(Messenger.c(this.baseTr.tr("summary", this.tr("key_name_pc", new Object[0]), this.colorText, counterNameText, Messenger.c(String.format("w %.2f", CounterUtils.tickToMinute(ticks))), realtimeSuffix, total, Messenger.c(String.format("w %.2f", (double)total / CounterUtils.tickToHour(ticks)))), "w  ", Messenger.fancy("nb", Messenger.s("[X]"), this.baseTr.tr("reset", this.colorText), Messenger.ClickEvents.runCommand(this.getSelfCommandBase() + " reset"))));
        this.counter.object2LongEntrySet().stream().sorted(this.getReportOrderComparator()).forEach(entry -> {
            DyeCounterKey key = (DyeCounterKey)entry.getKey();
            long count = entry.getLongValue();
            lines.add(Messenger.c("g - ", key.getText(), "g : ", CounterUtils.ratePerHourText(count, ticks, "www")));
        });
        return lines;
    }
}

