/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.lifetime;

import carpettisaddition.CarpetTISAdditionServer;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.lifetime.LifeTimeWorldTracker;
import carpettisaddition.commands.lifetime.filter.EntityFilterManager;
import carpettisaddition.commands.lifetime.interfaces.LifetimeTrackerTarget;
import carpettisaddition.commands.lifetime.interfaces.ServerWorldWithLifeTimeTracker;
import carpettisaddition.commands.lifetime.removal.RemovalReason;
import carpettisaddition.commands.lifetime.spawning.SpawningReason;
import carpettisaddition.utils.EntityUtils;
import carpettisaddition.utils.GameUtils;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class LifetimeTrackerTargetImpl
implements LifetimeTrackerTarget {
    private final class_1297 entity;
    private final LifeTimeWorldTracker tracker;
    private final int trackId;
    private final boolean doLifeTimeTracking;
    private boolean recordedSpawning;
    private long spawnTime;
    private class_243 spawningPos;
    private boolean recordedRemoval;
    private long removalTime;
    private class_243 removalPos;

    public LifetimeTrackerTargetImpl(class_1297 entity) {
        LifeTimeWorldTracker tracker;
        this.entity = entity;
        class_1937 world = EntityUtils.getEntityWorld(entity);
        this.recordedSpawning = false;
        this.recordedRemoval = false;
        if (world instanceof class_3218 && (tracker = ((ServerWorldWithLifeTimeTracker)world).getLifeTimeWorldTracker()) != null) {
            this.tracker = tracker;
            this.trackId = LifeTimeTracker.getInstance().getCurrentTrackId();
            this.doLifeTimeTracking = LifeTimeTracker.getInstance().willTrackEntity(entity, false);
            return;
        }
        this.tracker = null;
        this.trackId = -1;
        this.doLifeTimeTracking = false;
    }

    private void reset() {
        if (this.doLifeTimeTracking) {
            this.recordedSpawning = false;
            this.recordedRemoval = false;
        }
    }

    public boolean isActivated() {
        return this.doLifeTimeTracking;
    }

    @Override
    public int getTrackId() {
        return this.trackId;
    }

    @Override
    public long getLifeTime() {
        if (this.recordedSpawning && this.recordedRemoval) {
            return this.removalTime - this.spawnTime;
        }
        CarpetTISAdditionServer.LOGGER.warn("Try to query lifetime of {} without recording spawning or removal {} {}", (Object)this.entity, (Object)this.recordedSpawning, (Object)this.recordedRemoval);
        return -1L;
    }

    @Override
    public class_243 getSpawningPosition() {
        return Objects.requireNonNull(this.spawningPos, "Spawning is not recorded");
    }

    @Override
    public class_243 getRemovalPosition() {
        return Objects.requireNonNull(this.removalPos, "Removal is not recorded");
    }

    @Override
    public void recordSpawning(SpawningReason reason) {
        if (!this.doLifeTimeTracking) {
            return;
        }
        if (this.recordedSpawning && this.recordedRemoval && reason.getSpawningType().isDoubleRecordSupported()) {
            this.reset();
        }
        if (!this.recordedSpawning) {
            if (!EntityFilterManager.getInstance().test(this.entity)) {
                return;
            }
            if (CarpetTISAdditionSettings.lifeTimeTrackerConsidersMobcap && this.entity instanceof class_1308 && !GameUtils.countsTowardsMobcap(this.entity)) {
                return;
            }
            this.recordedSpawning = true;
            this.spawningPos = this.entity.method_73189();
            this.spawnTime = this.tracker.getSpawnStageCounter();
            this.tracker.onEntitySpawn(this.entity, reason);
        }
    }

    @Override
    public void recordRemoval(RemovalReason reason) {
        if (this.doLifeTimeTracking && this.recordedSpawning && this.spawningPos != null && !this.recordedRemoval) {
            if (!reason.getRemovalType().isValid(this.entity)) {
                return;
            }
            this.recordedRemoval = true;
            this.removalPos = this.entity.method_73189();
            this.removalTime = this.tracker.getSpawnStageCounter();
            this.tracker.onEntityRemove(this.entity, reason);
        }
    }
}

