/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.manipulate.chunk;

import carpettisaddition.commands.CommandTreeContext;
import carpettisaddition.commands.manipulate.AbstractManipulator;
import carpettisaddition.commands.manipulate.chunk.ChunkEraser;
import carpettisaddition.commands.manipulate.chunk.ChunkRelighter;
import carpettisaddition.commands.manipulate.chunk.ThrottledOperator;
import carpettisaddition.utils.Messenger;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class ChunkManipulator
extends AbstractManipulator {
    public ChunkManipulator() {
        super("chunk");
    }

    private LiteralArgumentBuilder<class_2168> makeBatchOperationNode(String subcommand, int maxRangeRadius, ThrottledOperator.OperateImpl operateImpl) {
        ThrottledOperator operator = new ThrottledOperator(this, operateImpl);
        BiFunction<String, BiFunction, LiteralArgumentBuilder> makeRadiusNode = (name, func) -> (LiteralArgumentBuilder)class_2170.method_9247((String)name).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)0, (int)maxRangeRadius)).executes(c -> (Integer)func.apply((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"radius"))));
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)subcommand).executes(c -> {
            Messenger.tell((class_2168)c.getSource(), Messenger.formatting(this.tr("help.danger_notice", new Object[0]), class_124.field_1061));
            Messenger.tell((class_2168)c.getSource(), this.tr("help.root", new Object[0]));
            return 0;
        })).then(class_2170.method_9247((String)"current").executes(c -> operator.operateCurrent((class_2168)c.getSource())))).then((ArgumentBuilder)makeRadiusNode.apply("square", operator::operateInSquare))).then((ArgumentBuilder)makeRadiusNode.apply("chebyshev", operator::operateInSquare))).then((ArgumentBuilder)makeRadiusNode.apply("circle", operator::operateInCircle))).then((ArgumentBuilder)makeRadiusNode.apply("euclidean", operator::operateInCircle))).then(class_2170.method_9247((String)"at").then(class_2170.method_9244((String)"chunkX", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"chunkZ", (ArgumentType)IntegerArgumentType.integer()).executes(c -> operator.operateAt((class_2168)c.getSource(), new class_1923(IntegerArgumentType.getInteger((CommandContext)c, (String)"chunkX"), IntegerArgumentType.getInteger((CommandContext)c, (String)"chunkZ")))))));
    }

    @Override
    public void buildSubCommand(CommandTreeContext.Node context) {
        context.node.then(this.makeBatchOperationNode("erase", 32, this::doEraseChunks)).then(this.makeBatchOperationNode("relight", 2, this::doRelightChunks));
    }

    private int doEraseChunks(class_2168 source, List<class_1923> chunkPosList, Runnable doneCallback) {
        ChunkEraser chunkEraser = new ChunkEraser(this.getTranslator().getDerivedTranslator("erase"), chunkPosList, source);
        chunkEraser.erase().thenRun(doneCallback);
        return chunkPosList.size();
    }

    private int doRelightChunks(class_2168 source, List<class_1923> chunkPosList, Runnable doneCallback) {
        ChunkRelighter chunkRelighter = new ChunkRelighter(this.getTranslator().getDerivedTranslator("relight"), chunkPosList, source);
        chunkRelighter.relight().thenRun(doneCallback);
        return chunkPosList.size();
    }
}

