/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.commands.speedtest.tester;

import carpettisaddition.CarpetTISAdditionMod;
import carpettisaddition.commands.speedtest.SpeedTestCommand;
import carpettisaddition.commands.speedtest.TestType;
import carpettisaddition.commands.speedtest.ping.PingHandler;
import carpettisaddition.commands.speedtest.ping.PongReceiver;
import carpettisaddition.commands.speedtest.session.SpeedTestServerSession;
import carpettisaddition.commands.speedtest.session.SpeedTestServerSessionHolder;
import carpettisaddition.commands.speedtest.session.SpeedTestSessionMessenger;
import carpettisaddition.commands.speedtest.session.SpeedTestSessionMessengerImpl;
import carpettisaddition.translations.TranslationContext;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class SpeedTestPinger
extends TranslationContext
implements SpeedTestServerSession,
PongReceiver {
    private final class_3222 player;
    private final int count;
    private final double intervalSec;
    private final SpeedTestServerSessionHolder sessionHolder;
    private final SpeedTestSessionMessenger messenger;
    private final Semaphore pongSemaphore = new Semaphore(0);
    private final Semaphore abortSemaphore = new Semaphore(0);
    private final PingHandler pingHandler = new PingHandler(this::abortCuzBadPongReceived);
    private final List<Long> pingNsList = Lists.newArrayList();

    public SpeedTestPinger(class_2168 source, class_3222 player, int count, double intervalSec, SpeedTestServerSessionHolder sessionHolder) {
        super(SpeedTestCommand.getInstance().getTranslator().getDerivedTranslator("ping_test"));
        this.player = player;
        this.count = count;
        this.intervalSec = intervalSec;
        this.sessionHolder = sessionHolder;
        this.messenger = new SpeedTestSessionMessengerImpl(TestType.PING, source);
    }

    @Override
    public void start() {
        this.sessionHolder.setFor(this.player, this);
        this.messenger.sendMessage(this.tr("start", this.count, Math.round(this.intervalSec * 1000.0)), true);
        Thread thread = new Thread(this::pingThread);
        thread.setName("TISCM-" + this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
    }

    private void pingThread() {
        try {
            this.pingLoop();
        }
        catch (InterruptedException e) {
            CarpetTISAdditionMod.LOGGER.error("{} is interrupted by {}", (Object)this.getClass().getSimpleName(), (Object)e);
        }
    }

    private void pingLoop() throws InterruptedException {
        for (int i = 1; i <= this.count; ++i) {
            long nextPingWaitNs;
            AtomicLong pingCost = new AtomicLong(0L);
            int index = i;
            this.pingHandler.pingClient(this.player.field_13987, (payload, pingNs) -> {
                List<Long> list = this.pingNsList;
                synchronized (list) {
                    this.pingNsList.add(pingNs);
                }
                this.messenger.sendMessage(this.tr("pinging", index, String.format("%.1f", (double)pingNs / 1000000.0)), true);
                pingCost.set(pingNs);
                this.pongSemaphore.release();
            });
            this.pongSemaphore.acquire();
            long l = nextPingWaitNs = i < this.count ? Math.max(0L, (long)(this.intervalSec * 1.0E9 - (double)pingCost.get())) : 0L;
            if (this.abortSemaphore.tryAcquire(nextPingWaitNs, TimeUnit.NANOSECONDS)) break;
        }
        this.sessionHolder.clearFor(this.player, this);
        this.report();
    }

    private void abortCuzBadPongReceived() {
        CarpetTISAdditionMod.LOGGER.warn("bad pong received, abort test");
        this.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report() {
        double pingMs;
        int cnt;
        List<Long> list = this.pingNsList;
        synchronized (list) {
            cnt = this.pingNsList.size();
            double pingNs = this.pingNsList.stream().mapToDouble(Long::doubleValue).average().orElse(-1.0);
            pingMs = pingNs / 1000000.0;
        }
        this.messenger.sendMessage(this.tr("done", cnt, String.format("%.2f", pingMs)), false);
    }

    @Override
    public void abort() {
        this.pongSemaphore.release();
        this.abortSemaphore.release();
    }

    @Override
    public SpeedTestSessionMessenger getMessenger() {
        return this.messenger;
    }

    @Override
    public void onPongReceived(class_2487 payload) {
        this.pingHandler.onPongReceived(payload);
    }
}

