/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.libs.net.fabricmc.mapping.tree;

import carpettisaddition.libs.net.fabricmc.mapping.tree.Mapped;
import java.util.function.ToIntFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class MappedImpl
implements Mapped {
    final ToIntFunction<String> namespaceMapper;
    final String[] names;
    @Nullable String comment;

    MappedImpl(ToIntFunction<String> namespaceMapper, String[] names) {
        this.namespaceMapper = namespaceMapper;
        this.names = names;
        this.comment = null;
    }

    @Override
    public String getName(String namespace) {
        int t = this.namespaceMapper.applyAsInt(namespace);
        return this.getName(t);
    }

    @Override
    public String getRawName(String namespace) {
        return this.names[this.namespaceMapper.applyAsInt(namespace)];
    }

    @Override
    public @Nullable String getComment() {
        return this.comment;
    }

    String getName(int namespace) {
        if (namespace >= this.names.length) {
            namespace = this.names.length - 1;
        }
        while (this.names[namespace].isEmpty()) {
            if (namespace == 0) {
                return "";
            }
            --namespace;
        }
        return this.names[namespace];
    }

    void setComment(@Nullable String comment) {
        this.comment = comment;
    }
}

