/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.carpet.hooks.ruleDisabling;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.SettingsManager;
import carpettisaddition.settings.TISCMRule;
import carpettisaddition.settings.TISCMRules;
import carpettisaddition.utils.Messenger;
import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={SettingsManager.class})
public abstract class SettingsManagerMixin {
    @ModifyVariable(method={"displayRuleMenu"}, at=@At(value="INVOKE", target="Lcarpet/api/settings/CarpetRule;categories()Ljava/util/Collection;", ordinal=0, remap=false), remap=false, argsOnly=true)
    private CarpetRule<?> addTiscmRuleDisablingMessage(CarpetRule<?> carpetRule, @Local(argsOnly=true) class_2168 source) {
        TISCMRules.get(carpetRule).flatMap(SettingsManagerMixin::getTiscmRuleDisableMessage).ifPresent(lines -> lines.forEach(msg -> Messenger.tell(source, msg)));
        return carpetRule;
    }

    private static Optional<List<class_5250>> getTiscmRuleDisableMessage(TISCMRule tiscmRule) {
        ArrayList lines = Lists.newArrayList();
        Consumer<List> addReasons = reasons -> reasons.forEach(reason -> lines.add(Messenger.formatting(Messenger.s("- " + reason), class_124.field_1079)));
        if (!tiscmRule.worksForCurrentMCVersion()) {
            lines.add(Messenger.formatting(Messenger.tr("carpettisaddition.misc.rule_disabling.unmatched_minecraft", new Object[0]), class_124.field_1061));
            addReasons.accept(tiscmRule.getMCVersionFailReasons());
        } else if (!tiscmRule.allRestrictionsSatisfied()) {
            lines.add(Messenger.formatting(Messenger.tr("carpettisaddition.misc.rule_disabling.unsatisfied_restriction", new Object[0]), class_124.field_1061));
            addReasons.accept(tiscmRule.getAllRestrictionsFailReasons());
        }
        return lines.isEmpty() ? Optional.empty() : Optional.of(lines);
    }
}

