/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.microtiming.events.blockstatechange;

import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1937.class})
public abstract class WorldMixin {
    private final ThreadLocal<Deque<class_2680>> previousBlockState = ThreadLocal.withInitial(ArrayDeque::new);

    @Shadow
    public abstract class_2680 method_8320(class_2338 var1);

    @Inject(method={"setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;II)Z"}, at={@At(value="HEAD")})
    private void startSetBlockState(class_2338 pos, class_2680 newState, int flags, int maxUpdateDepth, CallbackInfoReturnable<Boolean> cir) {
        if (MicroTimingLoggerManager.isLoggerActivated()) {
            class_2680 oldState = this.method_8320(pos);
            this.previousBlockState.get().push(oldState);
            MicroTimingLoggerManager.onSetBlockState((class_1937)this, pos, oldState, newState, null, flags, EventType.ACTION_START);
        }
    }

    @Inject(method={"setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;II)Z"}, at={@At(value="RETURN")})
    private void endSetBlockState(class_2338 pos, class_2680 newState, int flags, int maxUpdateDepth, CallbackInfoReturnable<Boolean> cir) {
        if (MicroTimingLoggerManager.isLoggerActivated() && !this.previousBlockState.get().isEmpty()) {
            class_2680 oldState = this.previousBlockState.get().pop();
            MicroTimingLoggerManager.onSetBlockState((class_1937)this, pos, oldState, newState, (Boolean)cir.getReturnValue(), flags, EventType.ACTION_END);
        }
    }

    @Inject(method={"tickBlockEntities"}, at={@At(value="HEAD")})
    private void cleanStack(CallbackInfo ci) {
        this.previousBlockState.get().clear();
    }
}

