/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.microtiming.events.tiletick;

import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.interfaces.ITileTickListWithServerWorld;
import carpettisaddition.utils.WorldUtils;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_6755;
import net.minecraft.class_6757;
import net.minecraft.class_6760;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_6757.class})
public abstract class TileTickListMixin<T> {
    private int oldListSize;

    @Inject(method={"scheduleTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/tick/ChunkTickScheduler;scheduleTick(Lnet/minecraft/world/tick/OrderedTick;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void startScheduleTileTickEvent(class_6760<T> orderedTick, CallbackInfo ci, long l, class_6755<T> chunkTickScheduler) {
        this.oldListSize = chunkTickScheduler.method_20825();
    }

    @Inject(method={"scheduleTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/tick/ChunkTickScheduler;scheduleTick(Lnet/minecraft/world/tick/OrderedTick;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void endScheduleTileTickEvent(class_6760<T> tt, CallbackInfo ci, long l, class_6755<T> chunkTickScheduler) {
        class_3218 serverWorld = ((ITileTickListWithServerWorld)((Object)this)).getServerWorld();
        if (serverWorld != null) {
            int delay = (int)(tt.comp_254() - WorldUtils.getWorldTime((class_1937)serverWorld));
            MicroTimingLoggerManager.onScheduleTileTickEvent((class_1937)serverWorld, tt.comp_252(), tt.comp_253(), delay, tt.comp_255(), chunkTickScheduler.method_20825() > this.oldListSize);
        }
    }

    @ModifyVariable(method={"tick(Ljava/util/function/BiConsumer;)V"}, at=@At(value="INVOKE", target="Ljava/util/function/BiConsumer;accept(Ljava/lang/Object;Ljava/lang/Object;)V", remap=false))
    private class_6760<T> preExecuteBlockTileTickEvent(class_6760<T> event) {
        class_3218 serverWorld = ((ITileTickListWithServerWorld)((Object)this)).getServerWorld();
        if (serverWorld != null) {
            MicroTimingLoggerManager.onExecuteTileTickEvent((class_1937)serverWorld, event, EventType.ACTION_START);
        }
        return event;
    }

    @ModifyVariable(method={"tick(Ljava/util/function/BiConsumer;)V"}, at=@At(value="INVOKE", target="Ljava/util/function/BiConsumer;accept(Ljava/lang/Object;Ljava/lang/Object;)V", shift=At.Shift.AFTER, remap=false))
    private class_6760<T> postExecuteBlockTileTickEvent(class_6760<T> event) {
        class_3218 serverWorld = ((ITileTickListWithServerWorld)((Object)this)).getServerWorld();
        if (serverWorld != null) {
            MicroTimingLoggerManager.onExecuteTileTickEvent((class_1937)serverWorld, event, EventType.ACTION_END);
        }
        return event;
    }
}

