/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.recipes.RecipePattern;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.tag.BaseData;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.data.tag.util.DataFileUtils;
import fi.dy.masa.malilib.util.game.RecipeBookUtils;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_10295;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_10355;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_5455;

public class RecipeStorage {
    private static final int MAX_PAGES = 8;
    private static final int MAX_RECIPES = 18;
    private static final RecipeStorage INSTANCE = new RecipeStorage(144);
    private final RecipePattern[] recipes;
    private int selected;
    private boolean dirty;

    public static RecipeStorage getInstance() {
        return INSTANCE;
    }

    public RecipeStorage(int recipeCount) {
        this.recipes = new RecipePattern[recipeCount];
        this.initRecipes();
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            this.clearRecipes();
        }
    }

    private void initRecipes() {
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = new RecipePattern();
        }
    }

    private void clearRecipes() {
        for (int i = 0; i < this.recipes.length; ++i) {
            this.clearRecipe(i);
        }
    }

    public int getSelection() {
        return this.selected;
    }

    public void changeSelectedRecipe(int index) {
        if (index >= 0 && index < this.recipes.length) {
            this.selected = index;
            this.dirty = true;
        }
    }

    public void scrollSelection(boolean forward) {
        this.changeSelectedRecipe(this.selected + (forward ? 1 : -1));
    }

    public int getFirstVisibleRecipeId() {
        return this.getCurrentRecipePage() * this.getRecipeCountPerPage();
    }

    public int getTotalRecipeCount() {
        return this.recipes.length;
    }

    public int getRecipeCountPerPage() {
        return 18;
    }

    public int getCurrentRecipePage() {
        return this.getSelection() / this.getRecipeCountPerPage();
    }

    @Nonnull
    public RecipePattern getRecipe(int index) {
        if (index >= 0 && index < this.recipes.length) {
            return this.recipes[index];
        }
        return this.recipes[0];
    }

    @Nonnull
    public RecipePattern getSelectedRecipe() {
        return this.getRecipe(this.getSelection());
    }

    public void storeCraftingRecipeToCurrentSelection(class_1735 slot, class_465<?> gui, boolean clearIfEmpty, boolean fromKeybind, class_310 mc) {
        this.storeCraftingRecipe(this.getSelection(), slot, gui, clearIfEmpty, fromKeybind, mc);
    }

    public void storeCraftingRecipe(int index, class_1735 slot, class_465<?> gui, boolean clearIfEmpty, boolean fromKeybind, class_310 mc) {
        this.getRecipe(index).storeCraftingRecipe(slot, gui, clearIfEmpty, fromKeybind, mc);
        this.dirty = true;
    }

    public void clearRecipe(int index) {
        this.getRecipe(index).clearRecipe();
        this.dirty = true;
    }

    public void onAddToRecipeBook(class_10297 entry) {
        class_310 mc = class_310.method_1551();
        for (RecipePattern recipe : this.recipes) {
            if (recipe.isEmpty()) continue;
            List<RecipeBookUtils.Type> types = recipe.getRecipeType() != null ? List.of(recipe.getRecipeType()) : List.of(RecipeBookUtils.Type.SHAPED, RecipeBookUtils.Type.SHAPELESS);
            if (!RecipeBookUtils.matchClientRecipeBookEntry((class_1799)recipe.getResult(), Arrays.asList(recipe.getRecipeItems()), (class_10297)entry, types, (class_310)mc)) continue;
            ItemScroller.debugLog("onAddToRecipeBook(): Positive Match for result stack: [{}] networkId [{}]", recipe.getResult().toString(), entry.comp_3262().comp_3267());
            recipe.storeNetworkRecipeId(entry.comp_3262());
            recipe.storeRecipeCategory(entry.comp_3265());
            recipe.storeRecipeDisplayEntry(entry);
            recipe.storeRecipeType(RecipeBookUtils.Type.fromRecipeDisplay((class_10295)entry.comp_3263()));
            break;
        }
    }

    private void readFromNBT(CompoundData data, @Nonnull class_5455 registryManager) {
        if (data == null || !data.contains("Recipes", 9)) {
            return;
        }
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i].clearRecipe();
        }
        ListData tagList = data.getList("Recipes");
        int count = tagList.size();
        for (int i = 0; i < count; ++i) {
            String recipeType;
            CompoundData tag = tagList.getCompoundAt(i);
            byte index = tag.getByte("RecipeIndex");
            if (index < 0 || index >= this.recipes.length) continue;
            this.recipes[index].readFromData(tag, registryManager);
            if (tag.contains("RecipeCategory", 8)) {
                this.recipes[index].storeRecipeCategory(RecipeBookUtils.getRecipeCategoryFromId((String)tag.getString("RecipeCategory")));
            }
            if (tag.contains("LastNetworkId", 3)) {
                this.recipes[index].storeNetworkRecipeId(new class_10298(tag.getInt("LastNetworkId")));
            }
            if (!tag.contains("RecipeType", 8) || (recipeType = tag.getString("RecipeType")).isEmpty()) continue;
            for (RecipeBookUtils.Type type : RecipeBookUtils.Type.values()) {
                if (!type.name().equalsIgnoreCase(recipeType)) continue;
                this.recipes[index].storeRecipeType(type);
            }
        }
        this.changeSelectedRecipe(data.getByte("Selected"));
    }

    private CompoundData writeToNBT(@Nonnull class_5455 registry) {
        ListData tagRecipes = new ListData();
        CompoundData data = new CompoundData();
        for (int i = 0; i < this.recipes.length; ++i) {
            String id;
            if (!this.recipes[i].isValid()) continue;
            RecipePattern entry = this.recipes[i];
            CompoundData tag = entry.writeToData(registry);
            tag.putByte("RecipeIndex", (byte)i);
            if (entry.getRecipeCategory() != null && !(id = RecipeBookUtils.getRecipeCategoryId((class_10355)entry.getRecipeCategory())).isEmpty()) {
                tag.putString("RecipeCategory", id);
            }
            if (entry.getNetworkRecipeId() != null) {
                tag.putInt("LastNetworkId", entry.getNetworkRecipeId().comp_3267());
            }
            if (entry.getRecipeType() != null) {
                tag.putString("RecipeType", entry.getRecipeType().name().toLowerCase());
            }
            tagRecipes.add((BaseData)tag);
        }
        data.put("Recipes", (BaseData)tagRecipes);
        data.putByte("Selected", (byte)this.selected);
        return data;
    }

    private String getFileName() {
        if (!Configs.Generic.SCROLL_CRAFT_RECIPE_FILE_GLOBAL.getBooleanValue()) {
            String worldName = StringUtils.getWorldOrServerName();
            if (worldName != null) {
                return "recipes_" + worldName + ".nbt";
            }
            return "recipes_unknown.nbt";
        }
        return "recipes.nbt";
    }

    private Path getSaveDirAsPath() {
        return FileUtils.getMinecraftDirectoryAsPath().resolve("itemscroller");
    }

    public void readFromDisk(@Nonnull class_5455 registry) {
        try {
            Path saveDir = this.getSaveDirAsPath();
            if (Files.isDirectory(saveDir, new LinkOption[0])) {
                Path file = saveDir.resolve(this.getFileName());
                if (Files.exists(file, new LinkOption[0])) {
                    CompoundData nbtIn = DataFileUtils.readCompoundDataFromNbtFile((Path)file);
                    if (nbtIn != null && !nbtIn.isEmpty()) {
                        this.initRecipes();
                        this.readFromNBT(nbtIn, registry);
                    } else {
                        ItemScroller.LOGGER.warn("readFromDisk(): Error reading recipes from file '{}'", (Object)file.toAbsolutePath());
                    }
                }
            } else {
                ItemScroller.LOGGER.warn("readFromDisk(): Error reading recipes saveDir '{}'", (Object)saveDir.toAbsolutePath());
            }
        }
        catch (Exception e) {
            ItemScroller.LOGGER.warn("readFromDisk(): Failed to read recipes from file", (Throwable)e);
        }
    }

    public void writeToDisk(@Nonnull class_5455 registry) {
        if (this.dirty) {
            try {
                Path saveDir = this.getSaveDirAsPath();
                if (!Files.exists(saveDir, new LinkOption[0])) {
                    FileUtils.createDirectoriesIfMissing((Path)saveDir);
                }
                if (Files.isDirectory(saveDir, new LinkOption[0])) {
                    Path fileTmp = saveDir.resolve(this.getFileName() + ".tmp");
                    Path fileReal = saveDir.resolve(this.getFileName());
                    CompoundData data = this.writeToNBT(registry);
                    DataFileUtils.writeCompoundDataToCompressedNbtFile((Path)fileTmp, (BaseData)data);
                    if (Files.exists(fileReal, new LinkOption[0])) {
                        Files.delete(fileReal);
                    }
                    Files.move(fileTmp, fileReal, new CopyOption[0]);
                    this.dirty = false;
                }
            }
            catch (Exception e) {
                ItemScroller.LOGGER.warn("writeToDisk(): Failed to write recipes to file!", (Throwable)e);
            }
        }
    }
}

