/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay;

import com.vladmarica.betterpingdisplay.Config;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BetterPingDisplayMod
implements ModInitializer {
    public static final String MODID = "betterpingdisplay";
    public static final Logger LOGGER = LogManager.getLogger((String)"betterpingdisplay");
    private static final String CONFIG_FILE_NAME = "betterpingdisplay.json";
    private static BetterPingDisplayMod INSTANCE;
    private Path configFilePath;
    private Config config = Config.fromDefault();

    public void onInitialize() {
        INSTANCE = this;
        this.configFilePath = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE_NAME);
        File configFile = this.configFilePath.toFile();
        if (configFile.exists()) {
            try {
                this.config = Config.fromFile(configFile);
                this.config.writeToFile(configFile);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to load config file", (Throwable)ex);
            }
        } else {
            try {
                LOGGER.warn("Could not find config file, creating a default one");
                this.config.writeToFile(configFile);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to write default config file", (Throwable)ex);
            }
        }
        LOGGER.info("BetterPingDisplay mod loaded");
    }

    public Config getConfig() {
        return this.config;
    }

    public Path getConfigFilePath() {
        return this.configFilePath;
    }

    public static BetterPingDisplayMod instance() {
        return INSTANCE;
    }
}

