/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;

public class Config {
    private static final int DEFAULT_PING_TEXT_COLOR = -6250336;
    private static final String DEFAULT_PING_TEXT_FORMAT = "%dms";
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Color.class, (Object)new ColorJsonAdapter()).create();
    private final ConfigData data;

    private Config(ConfigData configData) {
        this.data = configData;
        if (!this.data.pingTextFormatString.contains("%d")) {
            this.data.pingTextFormatString = DEFAULT_PING_TEXT_FORMAT;
        }
    }

    public Color getTextColor() {
        return this.data.pingTextColor;
    }

    public void setTextColor(Color color) {
        this.data.pingTextColor = color;
    }

    public String getTextFormatString() {
        return this.data.pingTextFormatString;
    }

    public void setTextFormatString(String textFormatString) {
        this.data.pingTextFormatString = textFormatString;
    }

    public boolean shouldAutoColorPingText() {
        return this.data.autoColorPingText;
    }

    public void setShouldAutoColorPingText(boolean shouldAutoColorPingText) {
        this.data.autoColorPingText = shouldAutoColorPingText;
    }

    public boolean shouldRenderPingBars() {
        return this.data.renderPingBars;
    }

    public void setShouldRenderPingBars(boolean shouldRenderPingBars) {
        this.data.renderPingBars = shouldRenderPingBars;
    }

    public void writeToFile(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            writer.write(gson.toJson((Object)this.data));
        }
    }

    public static Config fromDefault() {
        return new Config(new ConfigData());
    }

    public static Config fromFile(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            Config config = new Config((ConfigData)gson.fromJson((Reader)reader, ConfigData.class));
            return config;
        }
    }

    private static class ConfigData
    implements Serializable {
        @Expose
        private boolean autoColorPingText = true;
        @Expose
        private boolean renderPingBars = false;
        @Expose
        private Color pingTextColor = new Color(-6250336);
        @Expose
        private String pingTextFormatString = "%dms";

        private ConfigData() {
        }
    }

    private static class ColorJsonAdapter
    implements JsonDeserializer<Color>,
    JsonSerializer<Color> {
        private ColorJsonAdapter() {
        }

        public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String str = json.getAsJsonPrimitive().getAsString();
            return new Color(Integer.parseInt(str.substring(1), 16));
        }

        public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(String.format("#%02x%02x%02x", src.getRed(), src.getGreen(), src.getBlue()));
        }
    }
}

