/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import dev.tr7zw.entityculling.CullTask;
import dev.tr7zw.entityculling.Provider;
import dev.tr7zw.entityculling.versionless.EntityCullingVersionlessBase;
import dev.tr7zw.transition.mc.ClientUtil;
import dev.tr7zw.transition.mc.ComponentProvider;
import dev.tr7zw.transition.mc.GeneralUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2818;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_4604;
import net.minecraft.class_7923;

public abstract class EntityCullingModBase
extends EntityCullingVersionlessBase {
    public static EntityCullingModBase instance;
    public Set<class_2591<?>> blockEntityWhitelist = new HashSet();
    public Set<class_1299<?>> entityWhitelist = new HashSet();
    public Set<class_1299<?>> tickCullWhistelist = new HashSet();
    public CullTask cullTask;
    protected class_304 keybind = GeneralUtil.createKeyMapping((String)"key.entityculling.toggle", (int)-1, (String)"text.entityculling.title");
    protected class_304 keybindBoxes = GeneralUtil.createKeyMapping((String)"key.entityculling.toggleBoxes", (int)-1, (String)"text.entityculling.title");
    private Set<Function<class_2586, Boolean>> dynamicBlockEntityWhitelist = new HashSet<Function<class_2586, Boolean>>();
    private Set<Function<class_1297, Boolean>> dynamicEntityWhitelist = new HashSet<Function<class_1297, Boolean>>();
    private int tickCounter = 0;
    public double lastTickTime = 0.0;
    public class_4604 frustum = null;

    @Override
    public void onInitialize() {
        instance = this;
        super.onInitialize();
        this.culling = new OcclusionCullingInstance(this.config.tracingDistance, new Provider());
        this.cullTask = new CullTask(this.culling, this.blockEntityWhitelist, this.entityWhitelist);
        this.cullThread = new Thread((Runnable)this.cullTask, "CullThread");
        this.cullThread.setUncaughtExceptionHandler((thread, ex) -> LOGGER.error("The CullingThread has crashed! Please report the following stacktrace!", ex));
        this.initModloader();
    }

    public void worldTick() {
        this.cullTask.requestCull = true;
    }

    public void clientTick() {
        boolean ingame;
        if (!this.lateInit) {
            Optional entity;
            this.lateInit = true;
            this.cullThread.start();
            for (String blockId : this.config.blockEntityWhitelist) {
                Optional block = class_7923.field_41181.method_17966(GeneralUtil.getResourceLocation((String)blockId));
                block.ifPresent(b -> this.blockEntityWhitelist.add((class_2591<?>)b));
            }
            for (String entityType : this.config.tickCullingWhitelist) {
                entity = class_7923.field_41177.method_17966(GeneralUtil.getResourceLocation((String)entityType));
                entity.ifPresent(e -> this.tickCullWhistelist.add((class_1299<?>)e));
            }
            for (String entityType : this.config.entityWhitelist) {
                entity = class_7923.field_41177.method_17966(GeneralUtil.getResourceLocation((String)entityType));
                entity.ifPresent(e -> this.entityWhitelist.add((class_1299<?>)e));
            }
        }
        if (this.keybind.method_1434()) {
            if (this.pressed) {
                return;
            }
            this.pressed = true;
            boolean bl = enabled = !enabled;
            if (enabled) {
                ClientUtil.sendChatMessage((class_2561)ComponentProvider.literal((String)"Culling on").method_27692(class_124.field_1060));
            } else {
                ClientUtil.sendChatMessage((class_2561)ComponentProvider.literal((String)"Culling off").method_27692(class_124.field_1061));
            }
        } else {
            this.pressed = false;
        }
        if (this.keybindBoxes.method_1434()) {
            if (this.pressedBox) {
                return;
            }
            this.pressedBox = true;
            boolean bl = this.debugHitboxes = !this.debugHitboxes;
            if (this.debugHitboxes) {
                ClientUtil.sendChatMessage((class_2561)ComponentProvider.literal((String)"Debug Cullboxes on").method_27692(class_124.field_1060));
            } else {
                ClientUtil.sendChatMessage((class_2561)ComponentProvider.literal((String)"Debug Cullboxes off").method_27692(class_124.field_1061));
            }
        } else {
            this.pressedBox = false;
        }
        long start = System.nanoTime();
        class_310 client = class_310.method_1551();
        boolean bl = ingame = client.field_1687 != null && client.field_1724 != null && client.field_1724.field_6012 > 10;
        if (ingame && enabled) {
            boolean changed = false;
            if (this.tickCounter++ % this.config.captureRate == 0) {
                if (!this.config.skipEntityCulling) {
                    this.cullTask.setEntitiesForRendering(StreamSupport.stream(client.field_1687.method_18112().spliterator(), false).toList());
                }
                if (!this.config.skipBlockEntityCulling) {
                    HashMap<class_2338, class_2586> blockEntities = new HashMap<class_2338, class_2586>();
                    for (int x = -8; x <= 8; ++x) {
                        for (int z = -8; z <= 8; ++z) {
                            class_2818 chunk = client.field_1687.method_8497(client.field_1724.method_31476().field_9181 + x, client.field_1724.method_31476().field_9180 + z);
                            blockEntities.putAll(chunk.method_12214());
                        }
                    }
                    this.cullTask.setBlockEntities(blockEntities);
                }
                changed = true;
            }
            this.cullTask.setIngame(true);
            this.cullTask.setCameraMC(EntityCullingModBase.instance.config.debugMode ? client.field_1724.method_5836(0.0f) : client.field_1773.method_19418().method_71156());
            this.cullTask.requestCull = true;
            if (changed) {
                this.lastTickTime = (double)(System.nanoTime() - start) / 1000000.0;
            }
        } else {
            this.cullTask.setIngame(false);
            this.cullTask.setEntitiesForRendering(Collections.emptyList());
            this.cullTask.setBlockEntities(Collections.emptyMap());
            this.lastTickTime = (double)(System.nanoTime() - start) / 1000000.0;
        }
    }

    public abstract class_238 setupAABB(class_2586 var1, class_2338 var2);

    public boolean isDynamicWhitelisted(class_2586 entity) {
        for (Function<class_2586, Boolean> fun : this.dynamicBlockEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isDynamicWhitelisted(class_1297 entity) {
        for (Function<class_1297, Boolean> fun : this.dynamicEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void addDynamicBlockEntityWhitelist(Function<class_2586, Boolean> function) {
        this.dynamicBlockEntityWhitelist.add(function);
    }

    public void addDynamicEntityWhitelist(Function<class_1297, Boolean> function) {
        this.dynamicEntityWhitelist.add(function);
    }
}

