/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.api.mcbs.controller;

import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorNullTab;
import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorTab;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class McbsEditor {
    public static final McbsEditor INSTANCE = new McbsEditor();
    @NotNull
    private final Set<McbsEditorTab> _tabs = new LinkedHashSet<McbsEditorTab>();
    @NotNull
    private final Set<McbsEditorTab> _tabsImmutable = Collections.unmodifiableSet(this._tabs);
    @NotNull
    private McbsEditorTab _currentTab = McbsEditorNullTab.INSTANCE;
    private long _editCount = Long.MIN_VALUE;

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final long getEditCount() {
        return this._editCount;
    }

    public final void addEditCount() {
        ++this._editCount;
    }

    public final Collection<McbsEditorTab> getTabsReadOnly() {
        return this._tabsImmutable;
    }

    public final boolean addTab(@NotNull McbsEditorTab tab, boolean setAsCurrent) throws NullPointerException {
        Objects.requireNonNull(tab);
        boolean result = this._tabs.add(tab);
        if (result) {
            this.addEditCount();
        }
        if (setAsCurrent || this.getCurrentTab() == McbsEditorNullTab.INSTANCE) {
            this.setCurrentTab(tab);
        }
        return result;
    }

    public final boolean removeTab(@NotNull McbsEditorTab tab) throws NullPointerException {
        Objects.requireNonNull(tab);
        if (!this._tabs.remove(tab)) {
            return false;
        }
        if (tab == this._currentTab) {
            this._currentTab = McbsEditorNullTab.INSTANCE;
        }
        this.addEditCount();
        return true;
    }

    @NotNull
    public final McbsEditorTab getCurrentTab() {
        return this._currentTab;
    }

    public final void setCurrentTab(@Nullable McbsEditorTab tab) {
        if (tab == this._currentTab) {
            return;
        }
        if (tab == null || !this._tabs.contains(tab)) {
            tab = McbsEditorNullTab.INSTANCE;
        }
        this._currentTab = tab;
        this.addEditCount();
    }
}

