/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.api.mcbs.controller.tab;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorTab;
import com.thecsdev.betterstats.api.mcbs.model.McbsFile;
import com.thecsdev.betterstats.api.mcbs.view.statsview.StatsView;
import com.thecsdev.betterstats.api.mcbs.view.statsview.StatsViewUtils;
import com.thecsdev.betterstats.resources.BSSLang;
import com.thecsdev.commonmc.api.stats.IStatsProvider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class McbsEditorFileTab
extends McbsEditorTab {
    @ApiStatus.Internal
    public static final McbsEditorFileTab LOCALPLAYER = new McbsEditorFileTab(new McbsFile());
    @NotNull
    private final McbsFile mcbsFile;
    @NotNull
    private final StatsView.Filters _statFilters = new Filters();
    @Nullable
    private File _lastSaveFile;

    public McbsEditorFileTab(@NotNull McbsFile mcbsFile) throws NullPointerException {
        this.mcbsFile = Objects.requireNonNull(mcbsFile);
    }

    public McbsEditorFileTab(@NotNull File file) throws NullPointerException, IOException {
        this(new McbsFile());
        this.loadFrom(Objects.requireNonNull(file));
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.mcbsFile);
    }

    @Override
    public final boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(((McbsEditorFileTab)obj).mcbsFile, this.mcbsFile);
    }

    @Override
    @NotNull
    public final class_2561 getDisplayName() {
        if (this == LOCALPLAYER) {
            return BSSLang.gui_menubar_view_localPlayerStats();
        }
        if (this._lastSaveFile != null) {
            return class_2561.method_43470((String)this._lastSaveFile.getName());
        }
        return class_2561.method_43470((String)(this.getClass().getSimpleName() + "@" + this.hashCode()));
    }

    @NotNull
    public final IStatsProvider getStats() {
        return this.mcbsFile.getStats();
    }

    @NotNull
    public final StatsView getCurrentView() {
        return (StatsView)this._statFilters.getProperty(StatsView.class, StatsViewUtils.FID_STATSVIEW, StatsView.getDefault());
    }

    public final void setCurrentView(@NotNull StatsView view) throws NullPointerException {
        Objects.requireNonNull(view);
        this._statFilters.setProperty(StatsView.class, StatsViewUtils.FID_STATSVIEW, view);
        this.addEditCount();
    }

    @NotNull
    public final StatsView.Filters getStatFilters() {
        return this._statFilters;
    }

    public final void saveAs(@NotNull File file) throws IOException {
        Objects.requireNonNull(file);
        JsonObject json = this.mcbsFile.toJson();
        FileUtils.writeStringToFile((File)file, (String)new Gson().toJson((JsonElement)json), (Charset)StandardCharsets.UTF_8);
        this._lastSaveFile = file;
    }

    public final void loadFrom(@NotNull File file) throws IOException {
        Objects.requireNonNull(file);
        String json = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        this.mcbsFile.loadFromJson((JsonObject)new Gson().fromJson(json, JsonObject.class));
        this.addEditCount();
        this._lastSaveFile = file;
    }

    public final void loadStatsFrom(@NotNull IStatsProvider statsProvider) throws NullPointerException {
        Objects.requireNonNull(statsProvider);
        this.mcbsFile.getStats().clearAndAddAll(statsProvider);
        this.addEditCount();
    }

    @ApiStatus.Internal
    private final class Filters
    extends StatsView.Filters {
        private Filters() {
        }

        public final Object put(class_2960 key, Object value) {
            McbsEditorFileTab.this.addEditCount();
            return super.put((Object)key, value);
        }

        public void putAll(Map<? extends class_2960, ?> m) {
            McbsEditorFileTab.this.addEditCount();
            super.putAll(m);
        }

        public Object putIfAbsent(class_2960 key, Object value) {
            McbsEditorFileTab.this.addEditCount();
            return super.putIfAbsent((Object)key, value);
        }

        public Object computeIfAbsent(class_2960 key, Function<? super class_2960, ?> mappingFunction) {
            McbsEditorFileTab.this.addEditCount();
            return super.computeIfAbsent((Object)key, mappingFunction);
        }

        public Object computeIfPresent(class_2960 key, BiFunction<? super class_2960, ? super Object, ?> remappingFunction) {
            McbsEditorFileTab.this.addEditCount();
            return super.computeIfPresent((Object)key, remappingFunction);
        }

        public Object compute(class_2960 key, BiFunction<? super class_2960, ? super Object, ?> remappingFunction) {
            McbsEditorFileTab.this.addEditCount();
            return super.compute((Object)key, remappingFunction);
        }

        public Object remove(Object key) {
            McbsEditorFileTab.this.addEditCount();
            return super.remove(key);
        }

        public boolean remove(Object key, Object value) {
            McbsEditorFileTab.this.addEditCount();
            return super.remove(key, value);
        }

        public boolean replace(class_2960 key, Object oldValue, Object newValue) {
            McbsEditorFileTab.this.addEditCount();
            return super.replace((Object)key, oldValue, newValue);
        }

        public Object replace(class_2960 key, Object value) {
            McbsEditorFileTab.this.addEditCount();
            return super.replace((Object)key, value);
        }

        public void replaceAll(BiFunction<? super class_2960, ? super Object, ?> function) {
            McbsEditorFileTab.this.addEditCount();
            super.replaceAll(function);
        }

        public Object merge(class_2960 key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
            McbsEditorFileTab.this.addEditCount();
            return super.merge((Object)key, value, remappingFunction);
        }
    }
}

