/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.api.mcbs.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thecsdev.betterstats.api.mcbs.model.McbsStats;
import java.util.Objects;
import net.minecraft.class_155;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class McbsFile {
    @NotNull
    private final McbsStats stats = new McbsStats();

    @NotNull
    public final McbsStats getStats() {
        return this.stats;
    }

    @Contract(value="-> new")
    public final JsonObject toJson() {
        return this.saveToJson(new JsonObject());
    }

    @Contract(value="_ -> param1")
    public final JsonObject saveToJson(@NotNull JsonObject saveTo) throws NullPointerException {
        Objects.requireNonNull(saveTo);
        saveTo.addProperty("DataVersion", (Number)class_155.method_16673().comp_4026().comp_4038());
        saveTo.add("stats", (JsonElement)this.getStats().toJson());
        return saveTo;
    }

    @Contract(value="_ -> new")
    public static final McbsFile fromJson(@NotNull JsonObject json) throws NullPointerException {
        Objects.requireNonNull(json);
        McbsFile file = new McbsFile();
        file.loadFromJson(json);
        return file;
    }

    public final void loadFromJson(@NotNull JsonObject json) throws NullPointerException {
        Objects.requireNonNull(json);
        this.getStats().loadFromJson(McbsFile.getJsonObject(json, "stats"));
    }

    @ApiStatus.Internal
    @NotNull
    static final JsonObject getJsonObject(@NotNull JsonObject json, @NotNull String key) {
        JsonObject jobj;
        if (!json.has(key)) {
            return new JsonObject();
        }
        JsonElement jsonElement = json.get(key);
        return jsonElement instanceof JsonObject ? (jobj = (JsonObject)jsonElement) : new JsonObject();
    }
}

