/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.api.mcbs.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.thecsdev.betterstats.api.mcbs.model.McbsFile;
import com.thecsdev.commonmc.api.stats.IStatsProvider;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class McbsStats
implements IStatsProvider {
    private final ConcurrentHashMap<class_2960, ConcurrentHashMap<class_2960, Integer>> intStats = new ConcurrentHashMap();

    McbsStats() {
    }

    @ApiStatus.Internal
    private final void cleanUp() {
        for (Map.Entry<class_2960, ConcurrentHashMap<class_2960, Integer>> statTypeEntry : this.intStats.entrySet()) {
            statTypeEntry.getValue().entrySet().removeIf(e -> (Integer)e.getValue() == 0);
        }
        this.intStats.entrySet().removeIf(e -> ((ConcurrentHashMap)e.getValue()).isEmpty());
    }

    @NotNull
    public final ConcurrentHashMap<class_2960, ConcurrentHashMap<class_2960, Integer>> getIntValues() {
        this.cleanUp();
        return this.intStats;
    }

    @NotNull
    public final ConcurrentHashMap<class_2960, Integer> getIntValues(@NotNull class_2960 type) throws NullPointerException {
        Objects.requireNonNull(type);
        this.cleanUp();
        return this.intStats.computeIfAbsent(type, __ -> new ConcurrentHashMap());
    }

    public final <T> int getIntValue(@NotNull class_3445<T> stat) throws NullPointerException {
        return this.getIntValue(stat.method_14949(), stat.method_14951());
    }

    public final <T> int getIntValue(@NotNull class_3448<T> type, @NotNull T subject) throws NullPointerException, IllegalStateException {
        class_2960 statTypeId = class_7923.field_41193.method_10221(Objects.requireNonNull(type));
        class_2960 statSubjectId = type.method_14959().method_10221(Objects.requireNonNull(subject));
        if (statTypeId == null) {
            throw new IllegalStateException("StatType not registered: " + String.valueOf(type));
        }
        if (statSubjectId == null) {
            throw new IllegalStateException("Feature not registered: " + String.valueOf(subject));
        }
        return this.getIntValue(statTypeId, statSubjectId);
    }

    public final int getIntValue(@NotNull class_2960 type, @NotNull class_2960 subject) throws NullPointerException {
        return this.getIntValues(Objects.requireNonNull(type)).getOrDefault(Objects.requireNonNull(subject), 0);
    }

    public final <T> void setIntValue(@NotNull class_3445<T> stat, int value) throws NullPointerException {
        this.setIntValue(stat.method_14949(), stat.method_14951(), value);
    }

    public final <T> void setIntValue(@NotNull class_3448<T> type, @NotNull T subject, int value) throws NullPointerException, IllegalStateException {
        class_2960 statTypeId = class_7923.field_41193.method_10221(Objects.requireNonNull(type));
        class_2960 statSubjectId = type.method_14959().method_10221(Objects.requireNonNull(subject));
        if (statTypeId == null) {
            throw new IllegalStateException("StatType not registered: " + String.valueOf(type));
        }
        if (statSubjectId == null) {
            throw new IllegalStateException("Feature not registered: " + String.valueOf(subject));
        }
        this.setIntValue(statTypeId, statSubjectId, value);
    }

    public final void setIntValue(@NotNull class_2960 type, @NotNull class_2960 subject, int value) throws NullPointerException {
        if (value == 0) {
            ConcurrentHashMap<class_2960, Integer> map = this.getIntValues(Objects.requireNonNull(type));
            map.remove(Objects.requireNonNull(subject));
            if (map.isEmpty()) {
                this.intStats.remove(type);
            }
        } else {
            this.getIntValues(Objects.requireNonNull(type)).put(Objects.requireNonNull(subject), value);
        }
    }

    public final void addAll(@NotNull IStatsProvider statsProvider) {
        Objects.requireNonNull(statsProvider);
        if (statsProvider instanceof McbsStats) {
            McbsStats other = (McbsStats)statsProvider;
            other.forEach((statTypeId, statSubjectId, otherValue) -> {
                int thisValue = this.getIntValue(statTypeId, statSubjectId);
                this.setIntValue(statTypeId, statSubjectId, thisValue + otherValue);
            });
            return;
        }
        for (class_3448 statType : class_7923.field_41193) {
            for (Object statSubject : statType.method_14959()) {
                int otherValue2 = statsProvider.getIntValue(statType, statSubject);
                if (otherValue2 == 0) continue;
                int thisValue = this.getIntValue(statType, statSubject);
                this.setIntValue(statType, statSubject, thisValue + otherValue2);
            }
        }
    }

    public final void clearAndAddAll(@NotNull IStatsProvider statsProvider) throws NullPointerException {
        Objects.requireNonNull(statsProvider);
        this.clear();
        this.addAll(statsProvider);
    }

    public final void clear() {
        this.intStats.clear();
    }

    public final void forEach(@NotNull IntValueConsumer consumer) throws NullPointerException {
        Objects.requireNonNull(consumer);
        this.cleanUp();
        for (Map.Entry<class_2960, ConcurrentHashMap<class_2960, Integer>> statTypeEntry : this.intStats.entrySet()) {
            class_2960 statTypeId = statTypeEntry.getKey();
            for (Map.Entry<class_2960, Integer> statSubjectEntry : statTypeEntry.getValue().entrySet()) {
                class_2960 statSubjectId = statSubjectEntry.getKey();
                int value = statSubjectEntry.getValue();
                consumer.accept(statTypeId, statSubjectId, value);
            }
        }
    }

    @Contract(value="-> new")
    public final JsonObject toJson() {
        return this.saveToJson(new JsonObject());
    }

    @Contract(value="_ -> param1")
    public final JsonObject saveToJson(@NotNull JsonObject saveTo) throws NullPointerException {
        Objects.requireNonNull(saveTo);
        for (Map.Entry<class_2960, ConcurrentHashMap<class_2960, Integer>> statTypeEntry : this.getIntValues().entrySet()) {
            JsonObject json_statType = new JsonObject();
            saveTo.add(statTypeEntry.getKey().toString(), (JsonElement)json_statType);
            for (Map.Entry<class_2960, Integer> statEntry : statTypeEntry.getValue().entrySet()) {
                if (statEntry.getValue() == 0) continue;
                json_statType.addProperty(statEntry.getKey().toString(), (Number)statEntry.getValue());
            }
        }
        return saveTo;
    }

    public final void loadFromJson(@NotNull JsonObject json) throws NullPointerException {
        Objects.requireNonNull(json);
        this.clear();
        for (Map.Entry statTypeEntry : json.entrySet()) {
            class_2960 statTypeId;
            JsonObject json_statType = McbsFile.getJsonObject(json, (String)statTypeEntry.getKey());
            if (json_statType.isEmpty()) continue;
            try {
                statTypeId = class_2960.method_60654((String)((String)statTypeEntry.getKey()));
            }
            catch (class_151 e) {
                continue;
            }
            for (Map.Entry statEntry : json_statType.entrySet()) {
                class_2960 statId;
                if (!((JsonElement)statEntry.getValue()).isJsonPrimitive() || !((JsonElement)statEntry.getValue()).getAsJsonPrimitive().isNumber()) continue;
                try {
                    statId = class_2960.method_60654((String)((String)statEntry.getKey()));
                }
                catch (class_151 e) {
                    continue;
                }
                this.setIntValue(statTypeId, statId, ((JsonElement)statEntry.getValue()).getAsInt());
            }
        }
    }

    @FunctionalInterface
    public static interface IntValueConsumer {
        public void accept(@NotNull class_2960 var1, @NotNull class_2960 var2, int var3);
    }
}

