/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.api.mcbs.view;

import com.thecsdev.betterstats.api.mcbs.controller.McbsEditor;
import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorTab;
import com.thecsdev.betterstats.api.mcbs.view.tab.McbsEditorTabGUI;
import com.thecsdev.betterstats.mcbs.view.editor.MenubarPanel;
import com.thecsdev.betterstats.mcbs.view.editor.TabStripPanel;
import com.thecsdev.betterstats.resources.BSSSprites;
import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class McbsEditorGUI
extends TElement {
    @NotNull
    private final McbsEditor mcbsEditor;
    private long lastSeenEditCount;

    public McbsEditorGUI(@NotNull McbsEditor mcbsEditor) throws NullPointerException {
        this.mcbsEditor = Objects.requireNonNull(mcbsEditor);
    }

    @NotNull
    public final McbsEditor getMcbsEditor() {
        return this.mcbsEditor;
    }

    protected final void tickCallback() {
        if (this.lastSeenEditCount != this.mcbsEditor.getEditCount()) {
            this.clearAndInit();
        }
    }

    protected final void initCallback() {
        this.lastSeenEditCount = this.mcbsEditor.getEditCount();
        MenubarPanel menubar = new MenubarPanel(this.mcbsEditor);
        menubar.setBounds(0, 0, this.getBounds().width, 17);
        this.addRel(menubar);
        TabbedDocumentInterface tdi = new TabbedDocumentInterface();
        tdi.setBounds(0, 20, this.getBounds().width, this.getBounds().height - 20);
        this.addRel(tdi);
    }

    private final class TabbedDocumentInterface
    extends TElement {
        private TabbedDocumentInterface() {
        }

        public final void renderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.drawGuiSprite(BSSSprites.gui_editor_tab_background(), bb.x, bb.y, bb.width, bb.height, -1);
        }

        public final void postRenderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.drawGuiSprite(BSSSprites.gui_editor_tab_foreground(), bb.x, bb.y, bb.width, bb.height, -1);
        }

        protected final void initCallback() {
            TabStripPanel tablist = new TabStripPanel(McbsEditorGUI.this.mcbsEditor);
            tablist.setBounds(1, 1, this.getBounds().width - 2, 17);
            this.addRel(tablist);
            McbsEditorTab tab = McbsEditorGUI.this.mcbsEditor.getCurrentTab();
            McbsEditorTabGUI<McbsEditorTab> tabGui = McbsEditorTabGUI.createTabGui(tab);
            tabGui.setBounds(1, 18, this.getBounds().width - 2, this.getBounds().height - 19);
            this.addRel(tabGui);
        }
    }
}

