/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.api.mcbs.view.statsview;

import com.thecsdev.betterstats.api.client.registry.BClientRegistries;
import com.thecsdev.betterstats.api.mcbs.view.statsview.StatsView;
import com.thecsdev.betterstats.resources.BSSLang;
import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.scene.Node;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.label.TLabelElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.tooltip.TTooltip;
import com.thecsdev.commonmc.api.client.gui.widget.TCheckboxWidget;
import com.thecsdev.commonmc.api.client.gui.widget.TDropdownWidget;
import com.thecsdev.commonmc.api.client.gui.widget.stats.TCustomStatWidget;
import com.thecsdev.commonmc.api.client.gui.widget.stats.TEntityStatsWidget;
import com.thecsdev.commonmc.api.client.gui.widget.stats.TItemStatsWidget;
import com.thecsdev.commonmc.api.client.gui.widget.text.TSimpleTextFieldWidget;
import com.thecsdev.commonmc.api.stats.util.CustomStat;
import com.thecsdev.commonmc.api.stats.util.EntityStats;
import com.thecsdev.commonmc.api.stats.util.ItemStats;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class StatsViewUtils {
    public static final int GAP = 3;
    public static final class_2960 FID_STATSVIEW = class_2960.method_60655((String)"betterstats", (String)"statsview");
    public static final class_2960 FID_SEARCH = class_2960.method_60655((String)"betterstats", (String)"search_query");
    public static final class_2960 FID_EMPTYSTATS = class_2960.method_60655((String)"betterstats", (String)"show_empty_stats");

    private StatsViewUtils() {
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static final TLabelElement initGroupLabel(@NotNull TPanelElement panel, @NotNull class_2561 text) throws NullPointerException {
        Objects.requireNonNull(panel);
        Objects.requireNonNull(text);
        TLabelElement label = new TLabelElement();
        label.setBounds(panel.computeNextYBounds(17, 3));
        label.textProperty().set((Object)text, StatsViewUtils.class);
        label.textColorProperty().set((Object)-256, StatsViewUtils.class);
        panel.add((Node)label);
        return label;
    }

    public static void initDefaultFilters(@NotNull StatsView.FiltersInitContext context) {
        TPanelElement panel = context.getPanel();
        TLabelElement lbl_group = StatsViewUtils.initGroupLabel(panel, (class_2561)BSSLang.gui_statsview_filters());
        lbl_group.setBounds(lbl_group.getBounds().add(0, 0, 0, 8));
        lbl_group.textColorProperty().set((Object)-1, StatsViewUtils.class);
        lbl_group.textAlignmentProperty().set((Object)CompassDirection.CENTER, StatsViewUtils.class);
        StatsViewUtils.initStatsViewFilter(context);
    }

    public static final void initStatsViewFilter(@NotNull StatsView.FiltersInitContext context) throws NullPointerException {
        TPanelElement panel = context.getPanel();
        TDropdownWidget widget = new TDropdownWidget();
        widget.setBounds(panel.computeNextYBounds(20, 3));
        widget.tooltipProperty().set(__ -> TTooltip.of((class_2561)BSSLang.gui_statsview_filter_selectedView()), StatsViewUtils.class);
        panel.add((Node)widget);
        Collection entries = widget.getEntries();
        for (Map.Entry<class_2960, StatsView> st : BClientRegistries.STATS_VIEW.entrySet()) {
            entries.add(st.getValue());
        }
        widget.selectedEntryProperty().set((Object)context.getStatsView(), StatsViewUtils.class);
        widget.selectedEntryProperty().addChangeListener((p, o, n) -> context.setStatsView((StatsView)n));
    }

    public static final void initSearchFilter(@NotNull StatsView.FiltersInitContext context) throws NullPointerException {
        TPanelElement panel = context.getPanel();
        TSimpleTextFieldWidget widget = new TSimpleTextFieldWidget();
        widget.setBounds(panel.computeNextYBounds(20, 3));
        widget.placeholderProperty().set((Object)BSSLang.gui_statsview_filter_search(), StatsViewUtils.class);
        panel.add((Node)widget);
        widget.textProperty().set((Object)((String)context.getFilters().getProperty(String.class, FID_SEARCH, "")), StatsViewUtils.class);
        widget.textProperty().addChangeListener((p, o, n) -> context.getFilters().setProperty(String.class, FID_SEARCH, n));
    }

    public static final void initShowAllStatsFilter(@NotNull StatsView.FiltersInitContext context) throws NullPointerException {
        TPanelElement panel = context.getPanel();
        Bounds2i nextRect = panel.computeNextYBounds(20, 3);
        TCheckboxWidget checkbox = new TCheckboxWidget();
        checkbox.setBounds(nextRect.x, nextRect.y, 20, nextRect.height);
        panel.add((Node)checkbox);
        TLabelElement label = new TLabelElement();
        label.setBounds(nextRect.x + 25, nextRect.y, nextRect.width - 25, nextRect.height);
        label.setText((class_2561)BSSLang.gui_statsview_filter_showAllStats());
        panel.add((Node)label);
        checkbox.checkedProperty().set((Object)((Boolean)context.getFilters().getProperty(Boolean.class, FID_EMPTYSTATS, false)), StatsViewUtils.class);
        checkbox.checkedProperty().addChangeListener((p, o, n) -> context.getFilters().setProperty(Boolean.class, FID_EMPTYSTATS, n));
    }

    public static final void initGeneralStats(@NotNull TPanelElement panel, @NotNull class_2561 groupLabel, @NotNull Iterable<CustomStat> customStats) throws NullPointerException {
        StatsViewUtils.initGeneralStats(panel, groupLabel, customStats, null);
    }

    public static final void initGeneralStats(@NotNull TPanelElement panel, @NotNull class_2561 groupLabel, @NotNull Iterable<CustomStat> customStats, @Nullable Consumer<TCustomStatWidget> widgetPostProcessor) throws NullPointerException {
        Objects.requireNonNull(panel);
        Objects.requireNonNull(groupLabel);
        Objects.requireNonNull(customStats);
        Iterator<CustomStat> iterator = customStats.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        StatsViewUtils.initGroupLabel(panel, groupLabel);
        Bounds2i nextBounds = panel.computeNextYBounds(18, 3);
        while (iterator.hasNext()) {
            TCustomStatWidget widget = new TCustomStatWidget(iterator.next());
            widget.setBounds(nextBounds);
            if (widgetPostProcessor != null) {
                widgetPostProcessor.accept(widget);
            }
            panel.add((Node)widget);
            nextBounds = nextBounds.add(0, nextBounds.height + 3, 0, 0);
        }
    }

    public static final void initItemStats(@NotNull TPanelElement panel, @NotNull class_2561 groupLabel, @NotNull Iterable<ItemStats> itemStats) throws NullPointerException {
        StatsViewUtils.initItemStats(panel, groupLabel, itemStats, null);
    }

    public static final void initItemStats(@NotNull TPanelElement panel, @NotNull class_2561 groupLabel, @NotNull Iterable<ItemStats> itemStats, @Nullable Consumer<TItemStatsWidget> widgetPostProcessor) throws NullPointerException {
        int nextX;
        Objects.requireNonNull(panel);
        Objects.requireNonNull(groupLabel);
        Objects.requireNonNull(itemStats);
        Iterator<ItemStats> iterator = itemStats.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        StatsViewUtils.initGroupLabel(panel, groupLabel);
        int size = 20;
        Bounds2i nextBounds = panel.computeNextYBounds(0, 3);
        int startX = nextX = nextBounds.x;
        int endX = nextBounds.endX;
        int nextY = nextBounds.y;
        while (iterator.hasNext()) {
            TItemStatsWidget widget = new TItemStatsWidget(iterator.next());
            widget.setBounds(nextX, nextY, size, size);
            if (widgetPostProcessor != null) {
                widgetPostProcessor.accept(widget);
            }
            panel.add((Node)widget);
            if ((nextX += size + 3) + size <= endX) continue;
            nextX = startX;
            nextY += size + 3;
        }
    }

    public static final void initMobStats(@NotNull TPanelElement panel, @NotNull class_2561 groupLabel, @NotNull Iterable<EntityStats> mobStats) throws NullPointerException {
        StatsViewUtils.initMobStats(panel, groupLabel, mobStats, null);
    }

    public static final void initMobStats(@NotNull TPanelElement panel, @NotNull class_2561 groupLabel, @NotNull Iterable<EntityStats> mobStats, @Nullable Consumer<TEntityStatsWidget> widgetPostProcessor) throws NullPointerException {
        int nextX;
        Objects.requireNonNull(panel);
        Objects.requireNonNull(groupLabel);
        Objects.requireNonNull(mobStats);
        Iterator<EntityStats> iterator = mobStats.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        StatsViewUtils.initGroupLabel(panel, groupLabel);
        int size = 30;
        Bounds2i nextBounds = panel.computeNextYBounds(0, 3);
        int startX = nextX = nextBounds.x;
        int endX = nextBounds.endX;
        int nextY = nextBounds.y;
        while (iterator.hasNext()) {
            TEntityStatsWidget widget = new TEntityStatsWidget(iterator.next());
            widget.setBounds(nextX, nextY, size, size);
            if (widgetPostProcessor != null) {
                widgetPostProcessor.accept(widget);
            }
            panel.add((Node)widget);
            if ((nextX += size + 3) + size <= endX) continue;
            nextX = startX;
            nextY += size + 3;
        }
    }
}

