/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.api.mcbs.view.tab;

import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorFileTab;
import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorNullTab;
import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorSettingsTab;
import com.thecsdev.betterstats.api.mcbs.controller.tab.McbsEditorTab;
import com.thecsdev.betterstats.api.mcbs.view.tab.McbsEditorFileTabGUI;
import com.thecsdev.betterstats.api.mcbs.view.tab.McbsEditorNullTabGUI;
import com.thecsdev.betterstats.api.mcbs.view.tab.McbsEditorSettingsTabGUI;
import com.thecsdev.commonmc.api.client.gui.TElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class McbsEditorTabGUI<T extends McbsEditorTab>
extends TElement {
    @NotNull
    private final T editorTab;
    private long lastSeenTabEditCount;
    private static final Map<Class<?>, Function<?, ?>> FACTORIES = new HashMap();

    public McbsEditorTabGUI(@NotNull T editorTab) throws NullPointerException {
        this.editorTab = (McbsEditorTab)Objects.requireNonNull(editorTab);
    }

    @NotNull
    public final T getEditorTab() {
        return this.editorTab;
    }

    protected final void tickCallback() {
        if (this.lastSeenTabEditCount != ((McbsEditorTab)this.editorTab).getEditCount()) {
            this.clearAndInit();
        }
    }

    protected final void initCallback() {
        if (!this.isEmpty()) {
            throw new IllegalStateException("Already initialized. Please call #clearAndInit().");
        }
        this.lastSeenTabEditCount = ((McbsEditorTab)this.editorTab).getEditCount();
        this.initTabGuiCallback();
    }

    protected abstract void initTabGuiCallback();

    public static final <T extends McbsEditorTab> void registerFactory(@NotNull Class<T> tabType, @NotNull @NotNull Function<@NotNull T, @NotNull McbsEditorTabGUI<T>> tabGuiFactory) throws NullPointerException {
        Objects.requireNonNull(tabType);
        Objects.requireNonNull(tabGuiFactory);
        FACTORIES.put(tabType, tabGuiFactory);
    }

    @NotNull
    public static final <T extends McbsEditorTab> McbsEditorTabGUI<T> createTabGui(@Nullable T editorTab) throws NullPointerException {
        Objects.requireNonNull(editorTab);
        Function<@NotNull ?, @NotNull ?> factory = FACTORIES.get(editorTab.getClass());
        if (factory == null) {
            throw new IllegalStateException("No editor tab GUI factory registered for tab type: " + editorTab.getClass().getName());
        }
        return Objects.requireNonNull((McbsEditorTabGUI)((Object)factory.apply(editorTab)), "Editor tab GUI factory returned 'null' for " + String.valueOf(editorTab));
    }

    @ApiStatus.Internal
    public static final void bootstrap() {
        McbsEditorTabGUI.registerFactory(McbsEditorNullTab.class, McbsEditorNullTabGUI::new);
        McbsEditorTabGUI.registerFactory(McbsEditorFileTab.class, McbsEditorFileTabGUI::new);
        McbsEditorTabGUI.registerFactory(McbsEditorSettingsTab.class, McbsEditorSettingsTabGUI::new);
    }
}

