/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.client.gui.panel;

import com.thecsdev.betterstats.api.mcbs.view.statsview.StatsView;
import com.thecsdev.betterstats.api.mcbs.view.statsview.StatsViewUtils;
import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.scene.Node;
import com.thecsdev.common.util.TUtils;
import com.thecsdev.common.util.annotations.CallerSensitive;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.label.TLabelElement;
import com.thecsdev.commonmc.api.client.gui.misc.TFillColorElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.widget.TButtonWidget;
import com.thecsdev.commonmc.api.stats.util.SubjectStats;
import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StatsPageChooser
extends TFillColorElement.Flat {
    private final int pageCount;
    @NotNull
    private final StatsView.Filters filters;
    @NotNull
    private final class_2960 filterId;
    @NotNull
    private final TLabelElement label = new TLabelElement();
    @NotNull
    private final TButtonWidget btn_left = new TButtonWidget();
    @NotNull
    private final TButtonWidget btn_right = new TButtonWidget();
    @Deprecated
    public final Event<Consumer<Integer>> ePageChanged = EventFactory.createLoop((Object[])new Consumer[0]);

    public StatsPageChooser(int pageCount, @NotNull StatsView.Filters filters, @NotNull class_2960 filterId) throws NullPointerException, IllegalArgumentException {
        super(0x50000000, -16777216);
        if (pageCount < 1) {
            throw new IllegalArgumentException("Page count must be at least 1");
        }
        this.pageCount = pageCount;
        this.filters = Objects.requireNonNull(filters);
        this.filterId = Objects.requireNonNull(filterId);
        this.label.textAlignmentProperty().set((Object)CompassDirection.CENTER, StatsViewUtils.class);
        this.btn_left.getLabel().setText((class_2561)class_2561.method_43470((String)"<"));
        this.btn_right.getLabel().setText((class_2561)class_2561.method_43470((String)">"));
        this.refreshElements();
        this.btn_left.eClicked.register(__ -> this.setPageValue(this.getPageValue() - 1));
        this.btn_right.eClicked.register(__ -> this.setPageValue(this.getPageValue() + 1));
    }

    protected final void initCallback() {
        Bounds2i pbb = this.getBounds();
        this.label.setBounds(pbb);
        this.add((Node)this.label);
        this.btn_left.setBounds(pbb.x, pbb.y, 20, 20);
        this.add((Node)this.btn_left);
        this.btn_right.setBounds(pbb.endX - 20, pbb.y, 20, 20);
        this.add((Node)this.btn_right);
    }

    private final void refreshElements() {
        int pageValue = this.getPageValue();
        this.label.setText((class_2561)class_2561.method_43470((String)(pageValue + 1 + " / " + this.pageCount)));
        this.btn_left.enabledProperty().set((Object)(pageValue > 0 ? 1 : 0), StatsViewUtils.class);
        this.btn_right.enabledProperty().set((Object)(pageValue < this.pageCount - 1 ? 1 : 0), StatsViewUtils.class);
    }

    public final int getPageValue() {
        return Math.clamp((long)((Integer)this.filters.getProperty(Integer.class, this.filterId, 0)).intValue(), 0, this.pageCount - 1);
    }

    public final void setPageValue(int page) {
        int newValue;
        int oldValue = this.getPageValue();
        if (oldValue == (newValue = Math.clamp((long)page, 0, this.pageCount - 1))) {
            return;
        }
        this.filters.setProperty(Integer.class, this.filterId, newValue);
        this.refreshElements();
        ((Consumer)this.ePageChanged.invoker()).accept(newValue);
    }

    @ApiStatus.Internal
    private static final class_2960 getFilterID(@NotNull Class<?> caller) {
        Objects.requireNonNull(caller);
        return class_2960.method_60655((String)"betterstats", (String)("statspagechooser/generated/" + caller.getName().toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "_")));
    }

    @Nullable
    public static final StatsPageChooser initPanel(@NotNull TPanelElement target, @NotNull StatsView.Filters filters, int itemsPerPage, int itemsTotal) throws NullPointerException, IllegalArgumentException {
        if (itemsTotal < 1) {
            return null;
        }
        StatsPageChooser el = new StatsPageChooser((int)Math.max(Math.ceil((double)itemsTotal / (double)itemsPerPage), 1.0), filters, StatsPageChooser.getFilterID(TUtils.getStackWalkerRCR().getCallerClass()));
        el.setBounds(target.computeNextYBounds(20, 3));
        target.add((Node)el);
        return el;
    }

    @CallerSensitive
    public static final <SS extends SubjectStats<?>> Collection<SS> applyFilter(@NotNull Collection<SS> stats, @NotNull StatsView.Filters filters, int itemsPerPage) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(stats);
        Objects.requireNonNull(filters);
        if (itemsPerPage < 1) {
            throw new IllegalArgumentException("Items per page must be at least 1");
        }
        class_2960 fid = StatsPageChooser.getFilterID(TUtils.getStackWalkerRCR().getCallerClass());
        int pagesTotal = (int)Math.max(Math.ceil((double)stats.size() / (double)itemsPerPage), 1.0);
        int page = Math.clamp((long)((Integer)filters.getProperty(Integer.class, fid, 0)).intValue(), 0, pagesTotal - 1);
        return stats.stream().skip((long)page * (long)itemsPerPage).limit(itemsPerPage).toList();
    }
}

