/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.client.gui.panel;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.scene.Node;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.widget.stats.TTextualStatWidget;
import com.thecsdev.commonmc.api.stats.IStatsProvider;
import com.thecsdev.commonmc.api.stats.util.EntityStats;
import com.thecsdev.commonmc.api.stats.util.ItemStats;
import com.thecsdev.commonmc.api.stats.util.SubjectStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class StatsSummaryPanel
extends TPanelElement.Paintable {
    private static final int ENTRY_HEIGHT = 16;
    private final Collection<TTextualStatWidget> entries = new ArrayList<TTextualStatWidget>();

    public StatsSummaryPanel() {
        this.scrollPaddingProperty().set((Object)5, StatsSummaryPanel.class);
        this.outlineColorProperty().set((Object)-16777216, StatsSummaryPanel.class);
    }

    public StatsSummaryPanel(@NotNull Collection<? extends SubjectStats<?>> stats) {
        this();
        for (Map.Entry<class_3448<?>, Integer> entry : StatsSummaryPanel.summarizeStats(stats).entrySet()) {
            TTextualStatWidget widget = new TTextualStatWidget();
            widget.focusableProperty().set((Object)false, StatsSummaryPanel.class);
            widget.hoverableProperty().set((Object)false, StatsSummaryPanel.class);
            widget.backgroundColorProperty().set((Object)0, StatsSummaryPanel.class);
            widget.outlineColorProperty().set((Object)0, StatsSummaryPanel.class);
            widget.getKeyLabel().textProperty().set((Object)IStatsProvider.getStatTypeName(entry.getKey()), StatsSummaryPanel.class);
            widget.getValueLabel().textProperty().set((Object)class_2561.method_43470((String)Integer.toString(entry.getValue())), StatsSummaryPanel.class);
            this.entries.add(widget);
        }
    }

    public final Collection<TTextualStatWidget> getEntries() {
        return this.entries;
    }

    protected final void initCallback() {
        Bounds2i bb = this.getBounds();
        if (bb.width < 400) {
            for (TTextualStatWidget entry : this.getEntries()) {
                entry.setBounds(this.computeNextYBounds(16, 3));
                this.add((Node)entry);
            }
        } else {
            int padding = this.scrollPaddingProperty().getI();
            int halfWidth = (bb.width - 3 - padding * 2) / 2;
            int leftY = bb.y + padding;
            int rightY = bb.y + padding;
            boolean leftSide = true;
            for (TTextualStatWidget entry : this.getEntries()) {
                if (leftSide) {
                    entry.setBounds(bb.x + padding, leftY, halfWidth, 16);
                    leftY += 19;
                } else {
                    entry.setBounds(bb.x + padding + halfWidth + 3, rightY, halfWidth, 16);
                    rightY += 19;
                }
                leftSide = !leftSide;
                this.add((Node)entry);
            }
        }
    }

    @NotNull
    public static final LinkedHashMap<class_3448<class_1792>, Integer> summarizeItemStats(@NotNull Collection<ItemStats> stats) throws NullPointerException {
        return StatsSummaryPanel.summarizeStats(Objects.requireNonNull(stats));
    }

    @NotNull
    public static final LinkedHashMap<class_3448<class_1299<?>>, Integer> summarizeEntityStats(@NotNull Collection<EntityStats> stats) throws NullPointerException {
        return StatsSummaryPanel.summarizeStats(Objects.requireNonNull(stats));
    }

    @NotNull
    public static final LinkedHashMap<class_3448<?>, Integer> summarizeStats(@NotNull Collection<? extends SubjectStats<?>> stats) throws NullPointerException {
        return Objects.requireNonNull(stats).stream().flatMap(stat -> stat.getValues().entrySet().stream()).collect(Collectors.groupingBy(entry -> ((class_3445)entry.getKey()).method_14949(), LinkedHashMap::new, Collectors.summingInt(Map.Entry::getValue)));
    }

    public static final void initPanel(@NotNull TPanelElement target, @NotNull Collection<? extends SubjectStats<?>> stats) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(stats);
        if (stats.isEmpty()) {
            return;
        }
        StatsSummaryPanel panel = new StatsSummaryPanel(stats);
        panel.setBounds(target.computeNextYBounds(20, 3));
        panel.clearAndInit();
        Bounds2i pbb = panel.getBounds();
        Bounds2i cbb = panel.getContentBounds();
        panel.setBounds(pbb.x, pbb.y, pbb.width, cbb.height + panel.scrollPaddingProperty().getI() * 2);
        panel.clear();
        target.add((Node)panel);
    }
}

