/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.betterstats.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.thecsdev.betterstats.BetterStats;
import com.thecsdev.betterstats.mixin.hooks.AccessorStatsCounter;
import com.thecsdev.betterstats.resources.BSSLang;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import net.minecraft.class_12099;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StatisticsCommand {
    private static final SuggestionProvider<class_2168> SUGGEST_STAT = (context, builder) -> {
        @Nullable class_3448 statType = null;
        try {
            statType = (class_3448)class_7733.method_45602((CommandContext)context, (String)"stat_type", (class_5321)class_7924.field_41226).comp_349();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (statType == null) {
            return class_2232.method_9441().listSuggestions(context, builder);
        }
        @Nullable List<class_2960> suggestions = statType.method_14959().method_42021().stream().map(class_5321::method_29177).toList();
        return class_2172.method_9264(StreamSupport.stream(suggestions.spliterator(), false).map(Objects::toString), (SuggestionsBuilder)builder);
    };

    private StatisticsCommand() {
    }

    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher, @NotNull class_7157 buildContext) throws NullPointerException {
        LiteralArgumentBuilder statistics = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"statistics").requires(scs -> scs.method_75037().hasPermission(class_12099.field_63210))).then(StatisticsCommand.statistics_edit(buildContext))).then(StatisticsCommand.statistics_clear())).then(StatisticsCommand.statistics_query(buildContext));
        LiteralArgumentBuilder stats = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").requires(scs -> scs.method_75037().hasPermission(class_12099.field_63210))).then(StatisticsCommand.statistics_edit(buildContext))).then(StatisticsCommand.statistics_clear())).then(StatisticsCommand.statistics_query(buildContext));
        dispatcher.register(statistics);
        dispatcher.register(stats);
    }

    private static ArgumentBuilder<class_2168, ?> statistics_edit(@NotNull class_7157 cbc) throws NullPointerException {
        return class_2170.method_9247((String)"edit").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"stat_type", (ArgumentType)class_7733.method_45603((class_7157)cbc, (class_5321)class_7924.field_41226)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"stat", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_STAT).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> StatisticsCommand.execute_edit((CommandContext<class_2168>)ctx, true))))).then(class_2170.method_9247((String)"increase").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> StatisticsCommand.execute_edit((CommandContext<class_2168>)ctx, false)))))));
    }

    private static ArgumentBuilder<class_2168, ?> statistics_clear() {
        return class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(StatisticsCommand::execute_clear));
    }

    private static ArgumentBuilder<class_2168, ?> statistics_query(@NotNull class_7157 cra) throws NullPointerException {
        return class_2170.method_9247((String)"query").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"stat_type", (ArgumentType)class_7733.method_45603((class_7157)cra, (class_5321)class_7924.field_41226)).then(class_2170.method_9244((String)"stat", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_STAT).executes(StatisticsCommand::execute_query))));
    }

    private static int execute_edit(@NotNull CommandContext<class_2168> context, boolean setOrIncrease) throws NullPointerException {
        try {
            Collection arg_targets = class_2186.method_9312(context, (String)"targets");
            class_3448 arg_stat_type = (class_3448)class_7733.method_45602(context, (String)"stat_type", (class_5321)class_7924.field_41226).comp_349();
            class_2960 arg_stat = class_2232.method_9443(context, (String)"stat");
            int arg_value = IntegerArgumentType.getInteger(context, (String)"value");
            Object stat_object = arg_stat_type.method_14959().method_17966(arg_stat).orElse(null);
            Objects.requireNonNull(stat_object, "Registry entry '" + String.valueOf(arg_stat) + "' does not exist for registry '" + String.valueOf(arg_stat_type.method_14959()) + "'.");
            class_3445 stat = arg_stat_type.method_14956(stat_object);
            AtomicInteger affected = new AtomicInteger();
            for (class_3222 target : arg_targets) {
                if (target == null) continue;
                if (setOrIncrease) {
                    target.method_14248().method_15023((class_1657)target, stat, arg_value);
                } else {
                    target.method_14248().method_15022((class_1657)target, stat, arg_value);
                }
                affected.incrementAndGet();
                target.method_14248().method_14910(target);
            }
            ((class_2168)context.getSource()).method_9226(() -> BSSLang.cmd_stats_edit_out((class_2561)class_2561.method_43470((String)("[" + String.valueOf(class_7923.field_41193.method_10221((Object)arg_stat_type)) + " / " + String.valueOf(arg_stat) + "]")), affected.get()), false);
            return affected.get();
        }
        catch (Exception e) {
            StatisticsCommand.handleError(context, e);
            return -1;
        }
    }

    private static int execute_clear(@NotNull CommandContext<class_2168> context) throws NullPointerException {
        try {
            Collection targets = class_2186.method_9312(context, (String)"targets");
            AtomicInteger affected = new AtomicInteger();
            for (class_3222 target : targets) {
                if (target == null) continue;
                ((AccessorStatsCounter)target.method_14248()).getStats().clear();
                affected.incrementAndGet();
                target.field_13987.method_52396((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)BSSLang.cmd_stats_clear_kick()).method_27693("\n\n[EN]: Your statistics were cleared, which requires you to disconnect and re-join."));
            }
            ((class_2168)context.getSource()).method_9226(() -> BSSLang.cmd_stats_clear_out(affected.get()), false);
            return affected.get();
        }
        catch (Exception e) {
            StatisticsCommand.handleError(context, e);
            return -1;
        }
    }

    private static int execute_query(@NotNull CommandContext<class_2168> context) throws NullPointerException {
        try {
            class_3222 arg_target = class_2186.method_9315(context, (String)"target");
            if (arg_target == null) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Player not found.")).create();
            }
            class_3448 arg_stat_type = (class_3448)class_7733.method_45602(context, (String)"stat_type", (class_5321)class_7924.field_41226).comp_349();
            class_2960 arg_stat = class_2232.method_9443(context, (String)"stat");
            Object stat_object = arg_stat_type.method_14959().method_17966(arg_stat).orElse(null);
            Objects.requireNonNull(stat_object, "Registry entry '" + String.valueOf(arg_stat) + "' does not exist for registry '" + String.valueOf(arg_stat_type.method_14959()) + "'.");
            class_3445 stat = arg_stat_type.method_14956(stat_object);
            int statValue = arg_target.method_14248().method_15025(stat);
            ((class_2168)context.getSource()).method_9226(() -> BSSLang.cmd_stats_query_out(arg_target.method_5476(), (class_2561)class_2561.method_43470((String)("[" + String.valueOf(class_7923.field_41193.method_10221((Object)arg_stat_type)) + " / " + String.valueOf(arg_stat) + "]")), statValue), false);
            return statValue;
        }
        catch (Exception e) {
            StatisticsCommand.handleError(context, e);
            return -1;
        }
    }

    @ApiStatus.Internal
    public static void handleError(@NotNull CommandContext<class_2168> context, @NotNull Throwable throwable) throws NullPointerException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(throwable);
        String msg = "An unexpected error occurred trying to execute the /statistics command";
        if (throwable instanceof Error) {
            throw new Error("An unexpected error occurred trying to execute the /statistics command", throwable);
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.failed").method_27693(":\n    " + throwable.getMessage()));
        BetterStats.LOGGER.error("An unexpected error occurred trying to execute the /statistics command", throwable);
    }
}

